Synchrony
====

## Setup

### Development

#### Installing Dev Dependencies

##### Java Cryptography Extension (JCE)

Synchrony requires support for unlimited strength jurisdiction policy files for its encryption solution. This means we require the JCE to be installed on your machine. (This is for Oracle JDK 1.8 and below. Oracle JDK 1.9 and OpenJDK both support strong cryptography out of the box)

1. Download the JCE package from [here](http://www.oracle.com/technetwork/java/javase/downloads/jce8-download-2133166.html). Note: Make sure that you download the JCE that matches your version of the JDK.

2. Unzip the JCE package and move the two .jar files to the security folder of your JDK installation. On OSX this is found at:

        /Library/Java/JavaVirtualMachines/jdk[YOUR_JDK_VERSION].jdk/Contents/Home/jre/lib/security/

    Alternatively, if you are not on OSX, you can run the following command to find the directory:

        sudo find / -name US_export_policy.jar

##### Maven

See https://extranet.atlassian.com/display/RELENG/HOWTO+-+Setting+up+your+maven+settings+securely

##### NodeJS & NPM

You can install this through a package manager such as [Homebrew](http://brew.sh) or by following the instructions at the [nodejs website](https://nodejs.org/en/).

##### Leiningen

Leiningen is a build tool for Clojure projects.

1. Install Leiningen by following the instructions at [leiningen.org](http://leiningen.org)

##### Versioning hook

We use a small git commit-hook and release script to track the severity of
changes for the versioning process. Learn how it works and how to install it [on this page](https://pug.jira-dev.com/wiki/spaces/WD/pages/2823457863/Automated+Synchrony+versioning).

### Running the server in the REPL

Please go through following page if you are interested in looking at various Synchrony dev loops things 
and Knowledge transfer notes in 2020:  
https://hello.atlassian.net/wiki/spaces/~ggautam/pages/953451548/Synchrony+training+notes

When you start a repl it will automatically call synchrony.core/start!, which will start the server. 
If you want to restart synchrony without restarting the process, 
you can do (synchrony.core/stop!) and then (synchrony.core/start!), 
though usually you'd just modify the code on the fly, send it via repl connection, 
and it will be picked up by the server.

### Building

build synchrony.jar

    ./run build standalone

to build the minified synchrony.min.js javascript:

    ./run build-prod-cljs

to build dev version and watch/rebuild on changes using repl:

    lein fig -b dev

or connect Lein + Figwheel-main with `dev` configuration after running the following: 

    ./run with-env dev lein with-profile dev repl


to build minified version and watch/rebuild on changes (slow, could be useful for debugging):

Go to dev.cljs.edn and follow the steps to link synchrony.js in the heade.
configure the Look and feel section in Confluence. 
You should be able load synchrony.js instead of synchrony.min.js now.
See for frontend details: https://hello.atlassian.net/wiki/spaces/~ggautam/pages/968592426/Synchrony+frontend+dev+loop

### Running the app outside the REPL

    lein run

#### PostgreSQL

Installing PostgreSQL:

    brew install postgres

Once installed, create a database called `wikidocs` and execute the sql script found in `./dev-resources/schema-pg.sql`.

### The Interactive test page

Once you start the server (either from the repl or with `lein run`) you
should be able to access `http://localhost:10123/resources/tests/interactive.html`


## Writing Documentation(Obsolete)

We have documentation in the sources/docs folder, which can be built with

    rake docs:build

which writes it to resources/public/docs, and served (with live refresh) by running

    rake docs:serve
    
Not here anymore, the original docs can be seen at  dev-support/docs/old-run.txt

which makes it available under [http://localhost:8081](http://localhost:8081).

Please note that this documentation is included in the production
service and therefore is publicly visible.

## Running the tests

### Unit tests

From the command line:

    ./run test-all

### Functional tests

Go to Confluence server collab to see E2E tests

### Version numbers

Version numbers in branches other than `master` should follow semver with major.minor.patch-snapshot name to avoid confusion. For example:

    5.1.1-SNAPSHOT for release/5.1 branch

All versions built in `master` should follow semver and end with `-SNAPSHOT` to indicate that they are not released yet. For example:

    6.0.0-SNAPSHOT for master branch


### Database (only required for `lein run`)

To set up a database for persistence - we assume a postgres instance runs on
localhost and the user and schema are "wikidocs" - create the schema,

    psql -U wikidocs -h localhost wikidocs < dev-resources/schema-pg.sql


### Faye

We currently use our custom version of the Faye library which has some
patches for CORS support applied to it. You can find it here:
https://stash.atlassian.com/projects/SYNC/repos/faye/browse?at=refs%2Fheads%2Ffirst-class-cors

To rebuild it checkout the branch first-class-cors and run make. I just
copied the resulting faye-browser.js and faye-browser-min.js directly
into the synchrony repository (TODO is a better way with npm?).

### Release

To release a new version of Synchrony from a release/** or master branch for a final production version, you need to do the following:
* Find the target **Synchrony Server** build under target **Confluence Bundled Libraries <Conf Version>** project in Bamboo. Example:
  * https://server-syd-bamboo.internal.atlassian.com/browse/CBL-SYNCSERVER
  * https://server-syd-bamboo.internal.atlassian.com/browse/CBL85-SYNCSERVER
* Run the **release** task in the latest job for that build.

To do a milestone(hash) release (eg. `synchrony-5.1.8-dbe02752`) for testing purpose, you need to do the following:
* Find the target Synchrony Server build under target Confluence Bundled Libraries in Bamboo. Example:
  * https://server-syd-bamboo.internal.atlassian.com/browse/CBL-SYNCSERVER
* Create a branch with your own branch based on the target build. Note that if the branch name is `master` or `release/*`, it will be considered a final production release.
* Run the release task in the latest job for that custom build
