(defproject com.atlassian/synchrony "6.4.2-SNAPSHOT"
  :min-lein-version "2.11.2"
  :managed-dependencies [[org.apache.commons/commons-compress "1.28.0"]
                         [org.apache.commons/commons-lang3 "3.19.0"]
                         [commons-io/commons-io "2.20.0"]
                         [commons-fileupload/commons-fileupload "1.6.0"]
                         [org.jsoup/jsoup "1.16.2"]]
  :bom {:import [[io.netty/netty-bom "4.1.125.Final"]
                 [com.fasterxml.jackson/jackson-bom "2.16.0"]
                 [io.micrometer/micrometer-bom "1.14.6"]]}
  :dependencies [[org.clojure/clojure "1.12.3"]
                 [org.clojure/java.jdbc "0.7.12"] ; storage tests, storage dev convenience. probably should be used in ginga.jdbc for parse-uri
                 [org.clojure/core.async "0.4.500"] ; everywhere :(
                 [org.clojure/core.match "1.1.0"] ; synchrony.dsl
                 [org.clojure/data.csv "1.1.0"] ; watch pid for windows
                 [org.clojure/tools.logging "0.4.1"] ; all logging
                 [org.clojure/core.cache "0.7.2"] ; synchrony.auth
                 [aleph "0.7.0-alpha2"] ; all networking
                 [org.clojars.alesguzik/diff-match-patch "1.0"] ; synchrony.operation.diff
                 [better-cond "2.0.2"] ; used in bayeux server, synchrony.middleware.json
                 [prismatic/plumbing "0.5.5"] ; only map-keys
                 [com.google.guava/guava "33.5.0-jre"]
                 [commons-codec "1.19.0"] ; Pinning commons-codec to 1.14 to fix the security issue - See CONFSERVER-59890 - upgrade commons-codec to 1.14
                 [ch.qos.reload4j/reload4j "1.2.26"] ; our logging backend. customers may provide custom logger configuration for it, so it shouldn't be changed
                 [org.slf4j/slf4j-reload4j "1.7.36"] ; route slf4j to log4j
                 [com.fasterxml.jackson.core/jackson-core] ; for msgpack and cheshire
                 [com.fasterxml.jackson.core/jackson-databind] ; for msgpack and cheshire
                 [com.fasterxml.jackson.dataformat/jackson-dataformat-smile] ; for msgpack and cheshire
                 [com.fasterxml.jackson.dataformat/jackson-dataformat-cbor] ; for msgpack and cheshire
                 [cheshire "5.8.1"] ; json
                 [org.msgpack/jackson-dataformat-msgpack "0.9.6"] ; synchrony.msgpack. jackson is used by cheshire anyway, which we use for json
                 [hickory "0.7.0" :exclusions [org.clojure/clojurescript]] ; synchrony.html <- api, entity-api
                 [com.atlassian.confluence/auth-interceptor-nutcluster "4.0.1"] ; nutcluster cluster interceptor
                 [com.atlassian/nutcluster "4.0.5"] ; clustering
                 [com.atlassian/nutcluster-aws "4.0.1"] ; support aws clustering in nutcluster
                 [com.atlassian/nutcluster-kubernetes "4.0.0"] ; support kubernetes clustering in nutcluster
                 [functionalbytes/mount-lite "2.1.1"] ; state management (starting/stopping a database connection pool, web/tcp servers, pid watcher, etc.)
                 [clj-time "0.15.2"] ; datetime header middleware, ginga.datetime, loadtest
                 [com.mysema.querydsl/querydsl-sql "3.7.4" :exclusions [joda-time]] ; all storage
                 [com.nimbusds/nimbus-jose-jwt "10.5" :exclusions [net.minidev/json-smart]] ; ginga.jwt
                 [net.minidev/json-smart "2.6.0"] ; uplift transitive brought in by nimbus-jose-jwt
                 [clojurewerkz/propertied "1.3.0"] ; map->properties is used in s.storage.db to set pool datasource properties that come from ginga.jdbc according to db driver
                 [com.mchange/c3p0 "0.11.2"] ; db connection pool
                 [camel-snake-kebab "0.4.0"] ; options coercion in the entity-api
                 [ring/ring-core "1.8.2"] ; ring.{middleware,util}.* are used in http, entity-api, json middleware and tilt
                 [compojure "1.6.1"] ; routing
                 [environ "1.1.0"] ; env
                 [prismatic/schema "1.1.11"] ; entity api
                 [org.clj-commons/byte-transforms "0.2.2"] ; s.utils/reverse-hash, base64, snappy compression
                 [com.rpl/specter "1.1.6"] ; qualify-parents
                 [org.clojure/data.codec "0.1.1"] ; base64 for tilt and ginga.chash
                 [instaparse "1.4.10"] ; ginga.jdbc/parse-uri
                 [io.micrometer/micrometer-registry-jmx] ; micrometer used for application observability: jmx
                 [io.micrometer/micrometer-registry-statsd] ; micrometer used for application observability: statsd
                 ]
  :pom-plugins   [[com.atlassian.maven.plugins/license-maven-plugin "1.0.1"
                   {:configuration ([:nonMavenDependenciesFile "${user.dir}/dev-support/missing-non-maven-dependencies.properties"]
                                    [:licensesDirectory "${user.dir}/resources-all/generated-licensing/third-party-licensing/licenses/"]
                                    [:bomFile "${user.dir}/resources-all/generated-licensing/third-party-licensing/licenses/bom.csv"])}]]
  :plugins [[lein-bom "0.2.0-atlassian-1"]]
  :uberjar-name "synchrony-standalone-version.jar"
  :jar-inclusions [#"^\.third-party-licensing\\licenses\\.*\.((txt)|(csv))"],
  :uberjar-exclusions [#"apache-v2-license\.txt" #"changelog\.txt" #"release_notes.*" #"NOTICE.*"
                       #"DEPENDENCIES" #"^LICENSE$" #"ASL2\.0" #"missing-non-maven-dependencies\.properties"]
  :aot [synchrony.core]

  ;; Use the Atlassian maven cache. This requires setting the Artifactory key in
  ;; your personal ~/.lein/profiles.clj. You may also want to set it as a mirror
  ;; repository; an example of the format of both of these can be see in
  ;; `containers/build-test/profiles.clj`. Instructions on generating a personal
  ;; key are here:  https://extranet.atlassian.com/x/iaNKvQ
  ;;
  :repositories [["atlassian-internal"      "https://packages.atlassian.com/maven/repository/internal"]
                 ["atlassian-restricted"    "https://packages.atlassian.com/maven/restricted"]
                 ["atlassian-public-legacy" "https://packages.atlassian.com/maven-public-legacy"]]

  :profiles {:uberjar {:aot :all, :omit-source true}
             :dev [:base :clj-dev :clj-test :cljs :cljs-dev :cljs-test]
             :forensics [:dev :forensics-src]
             :clj-dev ^{:pom-scope :test} {:dependencies
                                     [[org.postgresql/postgresql "42.7.8"]
                                      ;;[net.sourceforge.jtds/jtds "1.3.1"] ;;cannot ship to BTF due to licensing issue
                                      ;;[com.oracle/oracle-jdbc15 "11.2.0.1.0"] ;;cannot ship to BTF due to licensing issue
                                      ;;[mysql/mysql-connector-java "8.0.33"] ;;cannot ship to BTF due to GPL
                                      [nrepl "1.5.1"]
                                      ]
                       :plugins [[lein-pprint "1.3.2"]]
                       :resource-paths ["resources-all/static-dev" "resources-all/generated-cljs-dev" "resources-all/generated-cljs-prod"]
                       :jvm-opts ^:replace ["-server"
                                            "-XX:+UseG1GC"
                                            "-XX:-OmitStackTraceInFastThrow"
                                            "-Dio.netty.leakDetection.level=paranoid"
                                            ;; uncomment lines below to enable jmx
                                            ; "-Djava.rmi.server.hostname=localhost"
                                            ; "-Dcom.sun.management.jmxremote.authenticate=false"
                                            ; "-Dcom.sun.management.jmxremote.ssl=false"
                                            ; "-Dcom.sun.management.jmxremote.port=1100"
                                            ; "-Dcom.sun.management.jmxremote.rmi.port=1100"
                                            ; "-Dcom.sun.management.jmxremote"
                                            #_"-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=5015"]}
             :clj-test ^{:pom-scope :test} {:dependencies
                                      [[org.hsqldb/hsqldb "2.7.4"]
                                       [com.h2database/h2 "1.4.200"]
                                       [org.clojure/test.check "1.1.1"]
                                       [juxt/iota "0.2.3"]
                                       [ring/ring-mock "0.6.2"]]}
             :cljs {:dependencies [[org.clojure/clojurescript "1.10.520"]]}
             :cljs-dev ^{:pom-scope :test} {:dependencies
                                            ;;jetty hardcoding can be removed once ring with newer version is released and used here.
                                            [[org.eclipse.jetty.websocket/websocket-server "9.4.36.v20210114"] ; for figwheel-main
                                             [org.eclipse.jetty/jetty-server "9.4.36.v20210114"] ; for ring-jetty-adapter
                                             [ring "1.8.2"] ; for figwheel-main
                                             [com.bhauman/figwheel-main "0.2.18"]
                                             [cider/piggieback "0.5.2"]
                                             [binaryage/devtools "0.9.10"]]
                                            :repl-options {:nrepl-middleware [cider.piggieback/wrap-cljs-repl]}}
             :cljs-test ^{:pom-scope :test} {:dependencies [[doo "0.1.11"]]}
             :forensics-src { :source-paths ["dev-support/scripts/forensics-repl"]}
             :run ~(some-> (System/getenv "RUN_CMD_PROFILE") read-string)}

  :test-paths ["test"]
  :test-selectors {:default (complement :slow)
                   :slow :slow
                   :all (constantly true)}
  :source-paths ["src"]
  :resource-paths ["resources-all/static" "resources-all/generated-licensing" "resources-all/generated-cljs-prod-for-distribution"]
  :aliases {"fig" ["trampoline" "run" "-m" "figwheel.main"]}
  :repl-options {:init (start!)
                 :timeout 120000 }; 2 minutes. repl that loads and starts synchrony with nutcluster clustering may not fit in default 30 seconds
  :main synchrony.core)
