require([
    'ajs',
    'jquery',
    'confluence/legacy',
    'confluence/meta',
    'confluence/request-access/request-access-util'
], function (AJS,
             $,
             Confluence,
             Meta,
             AccessUtil) {
    AJS.toInit(function () {
        var MAIL_SERVER_CONFIGURED = WRM.data.claim("com.atlassian.confluence.plugins.confluence-request-access-plugin:confluence-request-access-plugin-resources.mail-server-configured");
        // DOM element that includes the padlock will be the trigger, otherwise the inline dialog's arrow looks funny
        // as the the padlock is too small
        var $trigger = $("#system-content-items");
        // Figure out if the padlock is shown
        var padlockIsShown = $("#content-metadata-page-restrictions").length !== 0;
        var pageId = Meta.get("page-id");
        var requestAccessUser = Meta.get("remote-user");

        // If there is no padlock on the page, or the view is not from a share page email abort.
        if (!$trigger.length || !padlockIsShown || $("#editPageLink").length || !_isRequestEditAccess()) {
            return;
        }

        var loading = $(Confluence.Request.Access.loading());

        var requestAccessDialog = AJS.InlineDialog($trigger, "requestAccessDialog", _constructor, _getOptions());

        function _constructor($content, trigger, showPopup) {
            $content.css({"padding": "20px"}).html(Confluence.Request.Access.dialog({
                canRequestAccess: MAIL_SERVER_CONFIGURED && requestAccessUser
            }));
            $content.on("click", '#request-access-dialog-button', function (e) {
                e.stopPropagation();

                var requestAccessButtons = $content.find(".actions-result");
                requestAccessButtons.replaceWith(loading);

                // Logged in user requests access to the user requesting access
                AJS.trigger('analyticsEvent', {
                    name: 'confluence.request.access.plugin.request.access.to.page',
                    data: {
                        pageId: pageId,
                        requestAccessUser: requestAccessUser,
                        accessType: 'edit'
                    }
                });

                var requestAccessResultMessage = "";

                $.ajax({
                    url: Confluence.getContextPath() + "/rest/access/latest/page/restriction/" + pageId + "/request/edit",
                    type: "POST",
                    contentType: "application/json; charset=utf-8",
                    data: requestAccessUser,
                    success: function (data) {
                        if (data.users.length === 0) {
                            // Something went wrong and we received no recipients in this branch
                            // The best option is just to display an error
                            AJS.flag({
                                type: 'error',
                                title: AJS.I18n.getText('confluence.request.access.pagerestricted.access.request.not.sent.title'),
                                body: AJS.I18n.getText('confluence.request.access.pagerestricted.access.request.not.sent.message')
                            });
                            return;
                        }

                        AJS.flag({
                            type: 'success',
                            title: AJS.I18n.getText('confluence.request.access.pagerestricted.access.request.sent.title'),
                            body: AccessUtil.messageBody(data.users)
                        });
                    },
                    error: function (xhr) {
                        if (xhr.status == 412) {
                            requestAccessResultMessage = AJS.I18n.getText("confluence.request.access.no.mail.server");
                        } else if (xhr.status == 502) {
                            requestAccessResultMessage = AJS.I18n.getText("confluence.request.access.error.sending.email");
                        } else {
                            requestAccessResultMessage = AJS.I18n.getText("confluence.request.access.error");
                        }

                        AJS.flag({
                            type: 'error',
                            title: AJS.I18n.getText('confluence.request.access.pagerestricted.access.request.not.sent.title'),
                            body: requestAccessResultMessage
                        });
                    },
                    complete: function () {
                        loading.remove();
                        requestAccessDialog.hide();
                    }
                });
            });

            $content.on("click", '.aui-button.cancel', function (e) {
                // Logged in user explicitly denies access to the user requesting access
                requestAccessDialog.hide();
            });
            showPopup();
            return false;
        }

        function _getOptions() {
            return {
                offsetY: 2,
                offsetX: 0,
                width: 350,
                hideDelay: null,
                noBind: true,
                hideCallback: function () {
                    setTimeout(requestAccessDialog.hide(), 5000);
                }
            };
        }

        function _isRequestEditAccess() {
            var shareParam = window.location.search.match(/[\?&]requestEditAccess=/);
            return !!(shareParam && shareParam.length);
        }

        requestAccessDialog.show();

    });
});