/* globals define, AJS */
define('confluence-user-profile/avatar-picker/avatar-initials-panel', [
    'jquery',
    'underscore',
    'ajs',
    'confluence-user-profile/avatar-picker/initials-image-upload-and-crop',
], function ($, _, AJS, InitialsImageUploadAndCrop) {
    'use strict';

    function AvatarInitialsPanel(opts) {
        return this.init(opts);
    }

    // List of colors for the initials avatar background. Please note that these color values should be hard-coded instead of
    // using design tokens, as we are drawing an image and want the colors to be consistent, regardless of the theme used.
    const COLORS = {
        blue: {
            rgb: 'rgb(0, 82, 204)',
            name: AJS.I18n.getText('confluence.user.profile.avatar.initials.background.color.blue'),
        },
        teal: {
            rgb: 'rgb(0, 163, 191)',
            name: AJS.I18n.getText('confluence.user.profile.avatar.initials.background.color.teal'),
        },
        green: {
            rgb: 'rgb(0, 135, 90)',
            name: AJS.I18n.getText('confluence.user.profile.avatar.initials.background.color.green'),
        },
        yellow: {
            rgb: 'rgb(255, 153, 31)',
            name: AJS.I18n.getText('confluence.user.profile.avatar.initials.background.color.yellow'),
        },
        red: {
            rgb: 'rgb(222, 53, 11)',
            name: AJS.I18n.getText('confluence.user.profile.avatar.initials.background.color.red'),
        },
        purple: {
            rgb: 'rgb(82, 67, 170)',
            name: AJS.I18n.getText('confluence.user.profile.avatar.initials.background.color.purple'),
        },
        darkgray: {
            rgb: 'rgb(23, 43, 77)',
            name: AJS.I18n.getText('confluence.user.profile.avatar.initials.background.color.darkgray'),
        }
    }

    AvatarInitialsPanel.prototype.defaults = {
        panel: null,
        saveButton: null,
        cancelButton: null,
        onCrop: function () {},
        onExpanded: function () {},
        userInitials: '',
    };

    AvatarInitialsPanel.prototype.init = function (opts) {
        _.bindAll(this, 'initPanelContent', '_toggleSaveButtonEnabled', '_onUpdateDetails', 'hideMessage', 'getImageCropper');
        this.options = $.extend(true, {}, this.defaults, opts);
        this._$panel = this.options.panel;
        this._$saveButton = this.options.saveButton;

        const currentUserName = AJS.Meta.get('current-user-fullname');
        this.userInitials = currentUserName.split(' ', 4).map((x) => x.charAt(0)).join('') || '';

        this.initPanelContent();
        this._toggleSaveButtonEnabled(true);
        this.imageUploadAndCrop = new InitialsImageUploadAndCrop(
            this._$panel.find('.initials-avatar-builder-container'),
            {
                onCrop: this._onUpdateDetails,
                toggleSaveButtonEnabled: this._toggleSaveButtonEnabled,
                colors: COLORS
            },
        );

        this._$saveButton.click(
            function () {
                this.imageUploadAndCrop.submit();
            }.bind(this),
        );

        return this;
    };

    AvatarInitialsPanel.prototype.initPanelContent = function () {
        this._$panel.append(
            Confluence.Templates.User.Avatar.Picker.initialsImageBuilder({
                userInitials: this.userInitials,
                colors: COLORS,
            }),
        );

        this._$message = this._$panel.find('.initials-image-upload-and-crop-message');
    };

    AvatarInitialsPanel.prototype._onUpdateDetails = function (croppedDataURI) {
        this.options.onCrop(croppedDataURI);
    };

    AvatarInitialsPanel.prototype._toggleSaveButtonEnabled = function (opt_enable) {
        if (opt_enable === null) {
            opt_enable = this._$saveButton.prop('disabled');
        }

        if (opt_enable) {
            this._$saveButton.prop('disabled', false);
        } else {
            this._$saveButton.prop('disabled', true);
        }
    };

    AvatarInitialsPanel.prototype.hideMessage = function () {
        this._$message.hide();
    };

    AvatarInitialsPanel.prototype.getImageCropper = function() {
        return this.imageUploadAndCrop;
    };

    return AvatarInitialsPanel;
});
