/* globals define, AJS */
define('confluence-user-profile/avatar-picker/avatar-picker-dialog', [
    'jquery',
    'underscore',
    'confluence-user-profile/avatar-picker/avatar-initials-panel',
    'confluence-user-profile/avatar-picker/avatar-picker-panel',
], /**
 * @tainted AJS.I18n
 */
function ($, _, AvatarInitialsPanel, AvatarPickerPanel) {
    'use strict';

    function AvatarPickerDialog(opts) {
        _.bindAll(this, 'initDialogContent', 'hide', 'show', 'cancel');

        this.options = $.extend(true, {}, this.defaults, opts);
        this._$dialog = new AJS.Dialog(this.options.dialogOptions);
        this._isPickerDialog = this.options.dialogType === 'picker';
        this.initDialogContent();

        if (this.options.trigger) {
            this._$trigger = $(this.options.trigger);
            this._$trigger.click(_.bind(this.show, this));
        }

        return this;
    }

    AvatarPickerDialog.prototype.defaults = {
        dialogType: 'default',
        dialogOptions: {},
        onCrop: function () {},
        trigger: null,
    };

    AvatarPickerDialog.prototype.initDialogContent = function () {
        const isInitials = !this._isPickerDialog;
        let submitText, cancelText, dialogTitle;
        if (isInitials) {
            submitText = AJS.I18n.getText('confluence.user.profile.avatar.initials.save');
            cancelText = AJS.I18n.getText('confluence.user.profile.avatar.initials.cancel');
            dialogTitle = AJS.I18n.getText('confluence.user.profile.avatar.initials.details');
        } else {
            submitText = AJS.I18n.getText('confluence.user.profile.avatar.picker.save');
            cancelText = AJS.I18n.getText('confluence.user.profile.avatar.picker.cancel');
            dialogTitle = AJS.I18n.getText('confluence.user.profile.avatar.picker.details');
        }

        this._$dialog.addHeader(dialogTitle);
        this._$dialog.addPanel();
        this._$dialog.addSubmit(submitText);
        this._$dialog.addCancel(cancelText, this.cancel);

        const panelOptions = {
            panel: this._$dialog.getCurrentPanel().body,
            saveButton: this._$dialog.getCurrentPanel().page.buttonpanel.find('.button-panel-submit-button'),
            cancelButton: this._$dialog.getCurrentPanel().page.buttonpanel.find('.button-panel-cancel-link'),
            onCrop: this.options.onCrop,
            onExpanded: function (toggle) {
                $('#personal-avatar-picker-dialog').toggleClass('expanded', toggle);
            },
        };

        this.panel = isInitials
            ? new AvatarInitialsPanel(panelOptions)
            : new AvatarPickerPanel(panelOptions);
    };

    AvatarPickerDialog.prototype.hide = function () {
        this.panel.hideMessage();
        this._$dialog.hide();
        this.panel.getImageCropper().resetState();

    };

    AvatarPickerDialog.prototype.cancel = function () {
        this.panel.getImageCropper().restoreState();
        this.hide();
    };

    AvatarPickerDialog.prototype.setMessage = function (message) {
        this.panel.setMessage(message);
    };

    AvatarPickerDialog.prototype.show = function () {
        if (this._isPickerDialog) {
            this.panel.getImageCropper().saveState();
        }
        this._$dialog.show();
        $('#personal-avatar-picker-dialog .button-panel-submit-button, #personal-avatar-initials-dialog .button-panel-submit-button')
            .removeClass('button-panel-button')
            .addClass('aui-button aui-button-primary');
    };

    return AvatarPickerDialog;
});
