define("confluence-user-profile/avatar-picker/image-explorer",["jquery","underscore"],function(h,g){function b(a,d){this.init.apply(this,arguments)}b.scaleModes={fill:"fill",contain:"contain",containAndFill:"containAndFill"};b.zoomModes={localZoom:"localZoom",imageZoom:"imageZoom"};b.prototype.defaults={initialScaleMode:b.scaleModes.containAndFill,zoomMode:b.zoomModes.localZoom,emptyClass:"empty",scaleMax:1};b.prototype.init=function(a,d){this.$container=a;this._$imageView=this.$container.find(".image-explorer-image-view");
this._$sourceImage=this.$container.find(".image-explorer-source");this._$mask=this.$container.find(".image-explorer-mask");this._$dragDelegate=this.$container.find(".image-explorer-drag-delegate");this.$scaleSlider=this.$container.find(".image-explorer-scale-slider");this.options=g.extend({},this.defaults,d);this.imageProperties={};g.bindAll(this,"getImageSrc","setImageSrc","initImage","initDragDelegate","initScaleSlider","setInitialScale","getFillScale","getContainedScale","getCircularContainedScale",
"sliderValToScale","scaleToSliderVal","updateImageScale","resetImagePosition","resetScaleSlider","toggleEmpty","get$ImageView","get$SourceImage","get$Mask","get$DragDelegate","getMaskedImageProperties","showError","clearError","hasValidImage","_resetFromError","_removeError");this.toggleEmpty(!0);this._$sourceImage[0].naturalWidth&&(this.toggleEmpty(!1),this.initImage({target:this._$sourceImage[0]}));this._$sourceImage.on("load",this.initImage);this.initDragDelegate();this.initScaleSlider()};b.prototype.getImageSrc=
function(){return this._$sourceImage?this._$sourceImage.attr("src"):void 0};b.prototype.setImageSrc=function(a){this._$sourceImage&&this._$sourceImage.attr("src","").attr("src",a)};b.prototype.initImage=function(a){a=a.target;this.imageProperties.naturalWidth=a.naturalWidth;this.imageProperties.naturalHeight=a.naturalHeight;this._removeError();this.toggleEmpty(!1);this.setInitialScale()};b.prototype.initDragDelegate=function(){var a;this._$dragDelegate.draggable({start:g.bind(function(){a=this._$sourceImage.offset()},
this),drag:g.bind(function(d,c){this._$sourceImage.offset({top:a.top+c.position.top-c.originalPosition.top,left:a.left+c.position.left-c.originalPosition.left})},this),revert:!0,revertDuration:0})};b.prototype.initScaleSlider=function(){this.$scaleSlider.on("change",g.bind(function(a){this.updateImageScale(this.sliderValToScale(a.target.value))},this))};b.prototype.setInitialScale=function(){var a=this._$mask.width(),d=this._$mask.height(),c=this.imageProperties.naturalWidth,e=this.imageProperties.naturalHeight,
f=1;this.minScale=1;switch(this.options.initialScaleMode){case b.scaleModes.fill:this.minScale=f=this.getFillScale(c,e,a,d);break;case b.scaleModes.contain:this._$mask.hasClass("circle-mask")?this.minScale=f=this.getCircularContainedScale(c,e,a/2):this.minScale=f=this.getContainedScale(c,e,a,d);break;case b.scaleModes.containAndFill:this._$mask.hasClass("circle-mask")?this.minScale=this.getCircularContainedScale(c,e,a/2):this.minScale=this.getContainedScale(c,e,a,d),f=this.getFillScale(c,e,a,d)}this.maxScale=
Math.max(f,this.options.scaleMax);this.resetScaleSlider(this.scaleToSliderVal(f));this.updateImageScale(f,b.zoomModes.imageZoom);this.resetImagePosition();this.toggleEditingButtons(!0)};b.prototype.getFillScale=function(a,d,c,e){return Math.max(c/a,e/d)};b.prototype.getContainedScale=function(a,d,c,e){return Math.min(c/a,e/d)};b.prototype.getCircularContainedScale=function(a,d,c){return Math.cos(Math.atan(d/a))*c*2/a};b.prototype.sliderValToScale=function(a){a/=this.$scaleSlider.attr("max")-this.$scaleSlider.attr("min");
return this.minScale+a*(this.maxScale-this.minScale)};b.prototype.scaleToSliderVal=function(a){return(a-this.minScale)/(this.maxScale-this.minScale)*(this.$scaleSlider.attr("max")-this.$scaleSlider.attr("min"))};b.prototype.updateImageScale=function(a,d){var c=Math.round(a*this.imageProperties.naturalWidth);a=Math.round(a*this.imageProperties.naturalHeight);d=d||this.options.zoomMode;switch(d){case b.zoomModes.imageZoom:var e=-1*c/2;var f=-1*a/2;break;case b.zoomModes.localZoom:e=this._$sourceImage.width();
d=this._$sourceImage.height();var n=parseInt(this._$sourceImage.css("margin-left"),10),k=parseInt(this._$sourceImage.css("margin-top"),10);f=this._$sourceImage.position();var l=this._$imageView.width()/2,m=this._$imageView.height()/2;k=m-f.top-k;e=l-f.left-(l-f.left-n)/e*c;f=m-f.top-k/d*a}this._$sourceImage.width(c).height(a).css({"margin-left":Math.round(e)+"px","margin-top":Math.round(f)+"px"})};b.prototype.resetImagePosition=function(){this._$sourceImage.css({top:"50%",left:"50%"})};b.prototype.resetScaleSlider=
function(a){this.$scaleSlider.val(a).removeClass("disabled").prop("disabled",!1)};b.prototype.toggleEditingButtons=function(a){h(".profile-pic-upload-and-crop-container .rotate-left-button, .profile-pic-upload-and-crop-container .clear-image-button").toggle(a);h(".image-upload-field-replacement").toggle(!a)};b.prototype.toggleEmpty=function(a){this.$container.toggleClass(this.options.emptyClass,a)};b.prototype.get$ImageView=function(){return this._$imageView};b.prototype.get$SourceImage=function(){return this._$sourceImage};
b.prototype.get$Mask=function(){return this._$mask};b.prototype.get$DragDelegate=function(){return this._$dragDelegate};b.prototype.getMaskedImageProperties=function(){var a=this._$sourceImage.width()/this.imageProperties.naturalWidth,d=this._$sourceImage.height()/this.imageProperties.naturalHeight,c=this._$mask.position(),e=this._$sourceImage.position();c.top+=parseInt(this._$mask.css("margin-top"),10);c.left+=parseInt(this._$mask.css("margin-left"),10);e.top+=parseInt(this._$sourceImage.css("margin-top"),
10);e.left+=parseInt(this._$sourceImage.css("margin-left"),10);return{maskedAreaImageX:Math.round((c.left-e.left)/a),maskedAreaImageY:Math.round((c.top-e.top)/d),maskedAreaWidth:Math.round(this._$mask.width()/a),maskedAreaHeight:Math.round(this._$mask.height()/d)}};b.prototype.showError=function(a,d){this._removeError();this.toggleEmpty(!0);this.$container.addClass("error");a=h(aui.message.error({titleContent:a,content:d||"",closeable:!0}));a.appendTo(this._$imageView).css({"margin-top":-1*a.outerHeight()/
2}).attr("id","upload-error-message");a.on("messageClose",this._resetFromError);AJS.messages.setup()};b.prototype.clearError=function(){this._removeError();this._resetFromError()};b.prototype.hasValidImage=function(){return!(!this.getImageSrc()||!this._$sourceImage.prop("naturalWidth"))};b.prototype._resetFromError=function(){var a=this.hasValidImage();this.toggleEmpty(!a);this.$container.removeClass("error");g.isFunction(this.options.onErrorReset)&&this.options.onErrorReset(a?this.getImageSrc():
void 0)};b.prototype._removeError=function(){this._$imageView.find(".aui-message.aui-message-error").remove();this._$imageView.find(".aui-message.error").remove()};return b});