define('confluence-user-profile/avatar-picker/initials-image-upload-and-crop', [
        'jquery',
        'underscore',
    ]
    /**
     * @tainted AJS.I18n
     */, function ($, _) {
        'use strict';

        const MAX_INITIALS_LENGTH = 4;
        const DEFAULT_COLOR = 'blue';
        const DEFAULT_RGB_VALUE = 'rgb(0, 82, 204)';
        const FONT_SIZE_SMALL = 260;
        const FONT_SIZE_MEDIUM = 350;
        const FONT_SIZE_LARGE = 490;
        const FONT_COLOR_LIGHT = '#FFFFFF';
        const FONT_COLOR_DARK = '#000000';
        const FONT_NAME = 'Arial';

        function InitialsImageUploadAndCrop($container, opts) {
            this.init.apply(this, arguments);
        }

        InitialsImageUploadAndCrop.prototype.defaults = {
            onCrop: function () {},
            toggleSaveButtonEnabled: function () {},
            colors: {},
        };

        InitialsImageUploadAndCrop.prototype.init = function ($container, opts) {
            this.options = _.extend({}, this.defaults, opts);
            this.$container = $container;
            this.$initialsInput = this.$container.find('#initials-avatar-initials-input');
            this.canvas = this.$container.find('#initials-avatar-canvas')[0];

            _.bindAll(this, 'submit', 'handleInitialsChange', 'paintCanvas', 'validateInitialsInput');

            this.paintCanvas();

            this.$initialsInput.keyup(this.handleInitialsChange);

            $('.initials-avatar-color-option input[type="radio"]').change(
                _.bind(function (e) {
                    // Hide all checkmarks and show the one that corresponds to the selected color.
                    this.$container.find('.initials-color-option-checkmark').each(function () {
                        $(this).attr('hidden', true);
                    });
                    $(e.currentTarget).siblings('span').attr('hidden', false);

                    this.paintCanvas();
                }, this),
            );

            const initialAvatarBuilderForm = document.querySelector(".initials-avatar-builder-container form.prevent-form-submission");
            if (initialAvatarBuilderForm) {
                initialAvatarBuilderForm.addEventListener("submit", function(e) {
                    e.preventDefault();
                });
            }
        };

        InitialsImageUploadAndCrop.prototype.submit = function () {
            const croppedDataURI = this.canvas.toDataURL('image/jpeg', 1.0);

            _.isFunction(this.options.onCrop) && this.options.onCrop(croppedDataURI);
        };

        InitialsImageUploadAndCrop.prototype.handleInitialsChange = function () {
            this.validateInitialsInput();
            this.paintCanvas();
        };

        InitialsImageUploadAndCrop.prototype.validateInitialsInput = function () {
            const initials = this.$initialsInput.val();

            if (initials.length > 0 && initials.length <= MAX_INITIALS_LENGTH) {
                this.options.toggleSaveButtonEnabled(true);
            } else {
                this.options.toggleSaveButtonEnabled(false);
            }
        };

        InitialsImageUploadAndCrop.prototype.paintCanvas = function () {
            const initials = this.$initialsInput.val();
            const selectedColorEl = this.$container.find('input[name="initials-color"]:checked');
            let color;
            if (selectedColorEl.length > 0) {
                color = selectedColorEl.attr('id').replace('initials-color-', '');
            } else {
                color = DEFAULT_COLOR;
            }
            const rgb = this.options.colors[color].rgb || DEFAULT_RGB_VALUE;
            const fontColor = color === 'teal' || color === 'yellow' ? FONT_COLOR_DARK : FONT_COLOR_LIGHT;
            const canvas = this.canvas;
            const ctx = canvas.getContext('2d');
            const text = initials.trim().slice(0, 4).toUpperCase();
            let fontSize;
            switch (text.length) {
                case 4:
                    fontSize = FONT_SIZE_SMALL;
                    break;
                case 3:
                    fontSize = FONT_SIZE_MEDIUM;
                    break;
                default:
                    fontSize = FONT_SIZE_LARGE;
            }

            ctx.clearRect(0, 0, canvas.width, canvas.height);
            ctx.fillStyle = rgb;
            ctx.fillRect(0, 0, canvas.width, canvas.height);
            ctx.font = `${fontSize}px ${FONT_NAME}`;
            ctx.fillStyle = fontColor;
            ctx.textBaseline = 'middle';
            ctx.textAlign = 'center';
            let { actualBoundingBoxAscent, actualBoundingBoxDescent } = ctx.measureText(text);
            ctx.fillText(text, canvas.width / 2, canvas.height / 2 + (actualBoundingBoxAscent - actualBoundingBoxDescent) / 2);
        };

        InitialsImageUploadAndCrop.prototype.restoreState = function() {};

        InitialsImageUploadAndCrop.prototype.resetState = function() {};

        return InitialsImageUploadAndCrop;
    });
