var AJS = AJS || {};

AJS.$(function () {
    var revokeConfirmation = AJS.$("#revoke-confirmation-text").val(),
        revokeErrorMessage = AJS.$("#revoke-error-message").val(),
        revokeToken = function (token, revokeUrl) {
            if (!revokeUrl) {
                revokeOAuth1Token(token);
            } else {
                revokeOAuth2Token(revokeUrl, token);
            }
        },
        revokeOAuth1Token = function (token) {
            let baseUrl = AJS.$("#baseurl").attr("data-baseurl");
            let oauth1ConsumerName = AJS.$("#token-" + token + "-name").text();
            if (!confirm(AJS.format(revokeConfirmation, oauth1ConsumerName))) {
                return;
            }
            AJS.$.ajax({
                url: baseUrl + "/plugins/servlet/oauth/users/access-tokens/revoke",
                type: "POST",
                data: {token: token},
                success: function () {
                    removeTokenItemFromList(token);
                },
                error: function () {
                    alert(revokeErrorMessage);
                },
            });
        },
        revokeOAuth2Token = function (revokeUrl, token) {
            let oauth2ClientName = AJS.$("#token-" + token + "-name").text();
            if (!confirm(AJS.format(revokeConfirmation, oauth2ClientName))) {
                return;
            }
            AJS.$.ajax({
                url: revokeUrl,
                type: "POST",
                success: function () {
                    removeTokenItemFromList(token);
                },
                error: function () {
                    alert(revokeErrorMessage);
                },
            });
        },
        removeTokenItemFromList = function (token) {
            var tokenItem = AJS.$(".revoke[data-token$=" + token + "]").parents(".token-item");

            var nextDivider = tokenItem.next(".divider");
            var prevDivider = tokenItem.prev(".divider");
            if (nextDivider.length) {
                nextDivider.remove();
            } else if (prevDivider.length) {
                prevDivider.remove();
            }

            tokenItem.remove();
        };

    AJS.$(".revoke").each(function () {
        AJS.$(this).click(function (event) {
            revokeToken(this.getAttribute("data-token"), this.getAttribute("data-revokeurl"));
            event.preventDefault();
        });
    });

    AJS.$(".show-permissions-button").each(function () {
        AJS.$(this).click(function (event) {
            AJS.dialog2("#show-permissions-" + this.getAttribute("data-token") + "-dialog").show();
            event.preventDefault();
        })
    });

    AJS.$(".show-permissions-close-button").on('click', function (event) {
        AJS.dialog2("#show-permissions-" + this.getAttribute("data-token") + "-dialog").hide();
        event.preventDefault();
    });
});
