var AJS = AJS || {};

const DEFAULT_TAB = "incoming-authorizations";

AJS.$(() => {
    const tabsMenu = AJS.$("#authorized-apps-tabs .tabs-menu");

    // set the active tab according to the current URL
    const setActiveTab = () => {
        const searchParams = new URLSearchParams(window.location.search);
        const activeTab = searchParams.get("tab");

        AJS.tabs.change(tabsMenu.find(`a[href="#${activeTab || DEFAULT_TAB}"]`));
    };

    // setup tab URL routing
    const tabLinks = tabsMenu.find("a");

    tabLinks.click((event) => {
        const activeTab = event.target.getAttribute("href").substring(1);

        const searchParams = new URLSearchParams(window.location.search);
        searchParams.set("tab", activeTab);

        const newRelativePathQuery = window.location.pathname + "?" + searchParams.toString();
        history.pushState(null, "", newRelativePathQuery);
    });

    window.addEventListener("popstate", setActiveTab);

    setActiveTab();
});
