/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public abstract class ValidationUtils {
    private static Log logger = LogFactory.getLog((Class)(class$org$springframework$validation$ValidationUtils == null ? (class$org$springframework$validation$ValidationUtils = ValidationUtils.class$("org.springframework.validation.ValidationUtils")) : class$org$springframework$validation$ValidationUtils));
    static /* synthetic */ Class class$org$springframework$validation$ValidationUtils;

    public static void invokeValidator(Validator validator, Object object, Errors errors) {
        if (validator != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invoking validator [" + validator + "]"));
            }
            if (!validator.supports(object.getClass())) {
                throw new IllegalArgumentException("Validator " + validator.getClass() + " does not support " + object.getClass());
            }
            validator.validate(object, errors);
            if (logger.isDebugEnabled()) {
                if (errors.hasErrors()) {
                    logger.debug((Object)("Validator found " + errors.getErrorCount() + " errors"));
                } else {
                    logger.debug((Object)"Validator found no errors");
                }
            }
        }
    }

    public static void rejectIfEmpty(Errors errors, String field, String errorCode) {
        ValidationUtils.rejectIfEmpty(errors, field, errorCode, null, null);
    }

    public static void rejectIfEmpty(Errors errors, String field, String errorCode, String defaultMessage) {
        ValidationUtils.rejectIfEmpty(errors, field, errorCode, null, defaultMessage);
    }

    public static void rejectIfEmpty(Errors errors, String field, String errorCode, Object[] errorArgs, String defaultMessage) {
        Object value = errors.getFieldValue(field);
        if (value == null || !StringUtils.hasLength(value.toString())) {
            errors.rejectValue(field, errorCode, errorArgs, defaultMessage);
        }
    }

    public static void rejectIfEmptyOrWhitespace(Errors errors, String field, String errorCode) {
        ValidationUtils.rejectIfEmptyOrWhitespace(errors, field, errorCode, null, null);
    }

    public static void rejectIfEmptyOrWhitespace(Errors errors, String field, String errorCode, String defaultMessage) {
        ValidationUtils.rejectIfEmptyOrWhitespace(errors, field, errorCode, null, defaultMessage);
    }

    public static void rejectIfEmptyOrWhitespace(Errors errors, String field, String errorCode, Object[] errorArgs, String defaultMessage) {
        Object value = errors.getFieldValue(field);
        if (value == null || !StringUtils.hasText(value.toString())) {
            errors.rejectValue(field, errorCode, errorArgs, defaultMessage);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

