/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.delegation.properties;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.properties.PropertySetFactory;
import com.atlassian.util.profiling.UtilTimerStack;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.List;

public class DelegatingPropertySetFactory
implements PropertySetFactory {
    private final List propertySetFactories;

    public DelegatingPropertySetFactory(List propertySetFactories) {
        this.propertySetFactories = propertySetFactories;
    }

    public PropertySet getPropertySet(Entity entity) throws EntityException {
        PropertySet propertySet = null;
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_getPropertySet(" + entity.getName() + ")"));
        }
        for (int i = 0; i < this.propertySetFactories.size(); ++i) {
            PropertySetFactory setFactory = (PropertySetFactory)this.propertySetFactories.get(i);
            propertySet = setFactory.getPropertySet(entity);
            if (propertySet == null) continue;
            if (UtilTimerStack.isActive()) {
                UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_getPropertySet(" + entity.getName() + ")"));
            }
            return propertySet;
        }
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_getPropertySet(" + entity.getName() + ")"));
        }
        return null;
    }

    PropertySet getPropertySet(User user) {
        return null;
    }

    public List getPropertySetFactories() {
        return this.propertySetFactories;
    }
}

