/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.hibernate.properties;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.ExternalEntity;
import com.atlassian.user.UserManager;
import com.atlassian.user.impl.hibernate.DefaultHibernateExternalEntity;
import com.atlassian.user.impl.hibernate.DefaultHibernateUser;
import com.atlassian.user.impl.hibernate.ExternalEntityDAO;
import com.atlassian.user.impl.hibernate.repository.HibernateRepository;
import com.atlassian.user.properties.PropertySetFactory;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import java.util.HashMap;
import java.util.Map;

public class HibernatePropertySetFactory
implements PropertySetFactory {
    public static final String HIBERNATE_PROPERTY_SET = "hibernate";
    private final UserManager userManager;
    protected final ExternalEntityDAO externalEntityDAO;
    private final HibernateRepository repo;
    private static final String EXTERNAL_ENTITY = "EXT";
    private static final String LOCAL_USER = "LOC";

    public HibernatePropertySetFactory(UserManager userManager, ExternalEntityDAO externalEntityDAO, HibernateRepository repo) {
        this.userManager = userManager;
        this.externalEntityDAO = externalEntityDAO;
        this.repo = repo;
    }

    public PropertySet getPropertySet(Entity entity) throws EntityException {
        return this.getPropertySet(entity.getName());
    }

    private PropertySet getPropertySet(String entityName) throws EntityException {
        PropertySet propertySet = null;
        HashMap<String, Object> args = new HashMap<String, Object>();
        DefaultHibernateUser localUser = (DefaultHibernateUser)this.userManager.getUser(entityName);
        if (localUser != null) {
            args.put("entityId", new Long(localUser.getId()));
            args.put("entityName", "LOC_" + localUser.getName());
            args.put("configurationProvider", this.repo.getHibernateConfigurationProvider());
        } else {
            ExternalEntity externalEntity = this.externalEntityDAO.getExternalEntity(entityName);
            if (externalEntity == null) {
                externalEntity = new DefaultHibernateExternalEntity();
                ((DefaultHibernateExternalEntity)externalEntity).setName(entityName);
                ((DefaultHibernateExternalEntity)externalEntity).setType(EXTERNAL_ENTITY);
                this.externalEntityDAO.saveExternalEntity(externalEntity);
            }
            args.put("entityId", new Long(externalEntity.getId()));
            args.put("entityName", externalEntity.getType() + "_" + externalEntity.getName());
            args.put("configurationProvider", this.repo.getHibernateConfigurationProvider());
        }
        propertySet = this.getPropertySet(args);
        return propertySet;
    }

    protected PropertySet getPropertySet(HashMap args) {
        return PropertySetManager.getInstance((String)HIBERNATE_PROPERTY_SET, (Map)args);
    }
}

