/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.hibernate.search.query;

import com.atlassian.user.EntityException;
import com.atlassian.user.impl.RepositoryException;
import com.atlassian.user.impl.hibernate.repository.HibernateRepository;
import com.atlassian.user.impl.hibernate.search.query.HibernateAccessor;
import com.atlassian.user.search.DefaultSearchResult;
import com.atlassian.user.search.SearchResult;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.query.AbstractEntityQueryParser;
import com.atlassian.user.search.query.AllRepositoriesQueryContext;
import com.atlassian.user.search.query.BooleanQuery;
import com.atlassian.user.search.query.EmailTermQuery;
import com.atlassian.user.search.query.EntityQueryException;
import com.atlassian.user.search.query.EntityQueryParser;
import com.atlassian.user.search.query.ExternalEntitiesInGroupTwoTermQuery;
import com.atlassian.user.search.query.ExternalEntityNameTermQuery;
import com.atlassian.user.search.query.FullNameTermQuery;
import com.atlassian.user.search.query.GroupNameTermQuery;
import com.atlassian.user.search.query.GroupQuery;
import com.atlassian.user.search.query.GroupsOfExternalEntityTwoTermQuery;
import com.atlassian.user.search.query.GroupsOfUserTwoTermQuery;
import com.atlassian.user.search.query.MembershipQuery;
import com.atlassian.user.search.query.Query;
import com.atlassian.user.search.query.QueryContext;
import com.atlassian.user.search.query.TermQuery;
import com.atlassian.user.search.query.UserNameTermQuery;
import com.atlassian.user.search.query.UserQuery;
import com.atlassian.user.search.query.UsersInGroupTwoTermQuery;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.Criteria;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.expression.Criterion;
import net.sf.hibernate.expression.Expression;
import net.sf.hibernate.expression.Junction;
import net.sf.hibernate.expression.SimpleExpression;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class HibernateEntityQueryParser
extends AbstractEntityQueryParser
implements EntityQueryParser {
    private HibernateRepository repository;
    private HibernateAccessor accessor;
    static /* synthetic */ Class class$com$atlassian$user$impl$hibernate$DefaultHibernateUser;
    static /* synthetic */ Class class$com$atlassian$user$impl$hibernate$DefaultHibernateGroup;
    static /* synthetic */ Class class$com$atlassian$user$impl$hibernate$DefaultHibernateExternalEntity;

    public HibernateEntityQueryParser(HibernateRepository repository) {
        this.repository = repository;
        this.accessor = new HibernateAccessor(repository);
    }

    public SearchResult findUsers(Query query) throws EntityException {
        this.validateQuery(query);
        return this.parseQuery(query);
    }

    public SearchResult findGroups(Query query) throws EntityException {
        this.validateQuery(query);
        return this.parseQuery(query);
    }

    public SearchResult findUsers(Query query, QueryContext context) throws EntityException {
        this.validateQuery(query);
        if (context instanceof AllRepositoriesQueryContext || context.getRepositoryKeys().contains(this.repository.getKey()) || context.getRepositoryKeys().contains("_all_repositories_")) {
            return this.parseQuery(query);
        }
        return null;
    }

    public SearchResult findGroups(Query query, QueryContext context) throws EntityException {
        this.validateQuery(query);
        if (context instanceof AllRepositoriesQueryContext || context.getRepositoryKeys().contains(this.repository.getKey()) || context.getRepositoryKeys().contains("_all_repositories_")) {
            return this.parseQuery(query);
        }
        return null;
    }

    private StringBuffer constructLikeSearchTerm(StringBuffer searchParameter, String matchingRule) {
        if (matchingRule.equals("contains")) {
            searchParameter = searchParameter.insert(0, "%");
            searchParameter = searchParameter.append("%");
        } else if (matchingRule.equals("ends_with")) {
            searchParameter = searchParameter.insert(0, "%");
        } else if (matchingRule.equals("starts_with")) {
            searchParameter = searchParameter.append("%");
        }
        return searchParameter;
    }

    private String identifyProperty(TermQuery q) {
        String entityProperty = null;
        if (q instanceof UserNameTermQuery) {
            entityProperty = "name";
        } else if (q instanceof EmailTermQuery) {
            entityProperty = "email";
        } else if (q instanceof FullNameTermQuery) {
            entityProperty = "fullName";
        } else if (q instanceof GroupNameTermQuery) {
            entityProperty = "name";
        } else if (q instanceof GroupsOfUserTwoTermQuery) {
            entityProperty = "entity";
        }
        return entityProperty;
    }

    private SearchResult parseQuery(Query q) throws EntityException {
        Session session = SessionFactoryUtils.getSession((SessionFactory)this.repository.getSessionFactory(), (boolean)true);
        Query definingQuery = null;
        definingQuery = q instanceof BooleanQuery ? this.identifyDefiningQuery((BooleanQuery)q) : (TermQuery)q;
        List result = null;
        try {
            Criteria baseCriteria = this.getBaseCriteria(definingQuery, session);
            baseCriteria = this.identifyAndAddSearchCriteria(q, definingQuery, baseCriteria);
            result = baseCriteria.list();
        }
        catch (HibernateException e) {
            throw new RepositoryException(e);
        }
        return new DefaultSearchResult(new DefaultPager(result), this.repository.getName());
    }

    private Criteria identifyAndAddSearchCriteria(Query q, Query definingQuery, Criteria baseCriteria) throws EntityQueryException, HibernateException {
        if (q instanceof BooleanQuery) {
            return this.addSearchCriteria((BooleanQuery)q, definingQuery, baseCriteria);
        }
        return this.addSearchCriteria((TermQuery)q, baseCriteria);
    }

    private Criteria addSearchCriteria(BooleanQuery q, Query definingQuery, Criteria baseCriteria) throws EntityQueryException, HibernateException {
        Junction junction = null;
        if (definingQuery instanceof MembershipQuery) {
            return this.addMembershipSearchCriteria(q, definingQuery, baseCriteria);
        }
        junction = this.identifyAndOrJunction(q);
        baseCriteria.add((Criterion)junction);
        Iterator iter = q.getQueries().iterator();
        while (iter.hasNext()) {
            Query query = (Query)iter.next();
            if (query instanceof BooleanQuery) {
                this.addSearchCriteria((BooleanQuery)query, definingQuery, baseCriteria);
                continue;
            }
            if (query instanceof TermQuery) {
                junction.add((Criterion)this.getQueryExpression((TermQuery)query));
                continue;
            }
            throw new EntityQueryException("Unknown query type: [" + query.getClass().getName() + "]");
        }
        return baseCriteria;
    }

    private Junction identifyAndOrJunction(BooleanQuery q) {
        Object junction = q.isAND() ? Expression.conjunction() : Expression.disjunction();
        return junction;
    }

    private Criteria addMembershipSearchCriteria(BooleanQuery q, Query definingQuery, Criteria baseCriteria) throws HibernateException {
        if (q instanceof GroupsOfUserTwoTermQuery) {
            this.addGroupsOfUserSearchCriteria(q, baseCriteria);
        } else if (q instanceof GroupsOfExternalEntityTwoTermQuery) {
            this.addGroupsOfExternalEntitySearchCriteria(q, baseCriteria);
        }
        return baseCriteria;
    }

    private void addGroupsOfUserSearchCriteria(BooleanQuery q, Criteria baseCriteria) throws HibernateException {
        StringBuffer term;
        UserNameTermQuery uQuery = ((GroupsOfUserTwoTermQuery)q).getUserNameTermQuery();
        GroupNameTermQuery gQuery = ((GroupsOfUserTwoTermQuery)q).getGroupNameTermQuery();
        if (!gQuery.getTerm().equals("*")) {
            if (gQuery.isMatchingSubstring()) {
                term = this.constructLikeSearchTerm(new StringBuffer(gQuery.getTerm()), gQuery.getMatchingRule());
                baseCriteria.add((Criterion)Expression.like((String)"name", (Object)term.toString()));
            } else {
                baseCriteria.add((Criterion)Expression.eq((String)"name", (Object)gQuery.getTerm()));
            }
        }
        if (uQuery.isMatchingSubstring()) {
            term = this.constructLikeSearchTerm(new StringBuffer(uQuery.getTerm()), uQuery.getMatchingRule());
            baseCriteria.createCriteria("localMembers").add((Criterion)Expression.like((String)"name", (Object)term.toString()));
        } else {
            baseCriteria.createCriteria("localMembers").add((Criterion)Expression.eq((String)"name", (Object)uQuery.getTerm()));
        }
    }

    private void addGroupsOfExternalEntitySearchCriteria(BooleanQuery q, Criteria baseCriteria) throws HibernateException {
        StringBuffer term;
        ExternalEntityNameTermQuery eQuery = ((GroupsOfExternalEntityTwoTermQuery)q).getExternalEntityNameTermQuery();
        GroupNameTermQuery gQuery = ((GroupsOfExternalEntityTwoTermQuery)q).getGroupNameTermQuery();
        if (!gQuery.getTerm().equals("*")) {
            if (gQuery.isMatchingSubstring()) {
                term = this.constructLikeSearchTerm(new StringBuffer(gQuery.getTerm()), gQuery.getMatchingRule());
                baseCriteria.add((Criterion)Expression.like((String)"name", (Object)term.toString()));
            } else {
                baseCriteria.add((Criterion)Expression.eq((String)"name", (Object)gQuery.getTerm()));
            }
        }
        if (eQuery.isMatchingSubstring()) {
            term = this.constructLikeSearchTerm(new StringBuffer(eQuery.getTerm()), eQuery.getMatchingRule());
            baseCriteria.createCriteria("externalMembers").add((Criterion)Expression.like((String)"name", (Object)term.toString()));
        } else {
            baseCriteria.createCriteria("externalMembers").add((Criterion)Expression.eq((String)"name", (Object)eQuery.getTerm()));
        }
    }

    private Criteria addSearchCriteria(TermQuery q, Criteria baseCriteria) {
        SimpleExpression expression = this.getQueryExpression(q);
        baseCriteria.add((Criterion)expression);
        return baseCriteria;
    }

    private SimpleExpression getQueryExpression(TermQuery q) {
        SimpleExpression expression = null;
        String hqlField = this.identifyProperty(q);
        if (q.isMatchingSubstring()) {
            StringBuffer term = this.constructLikeSearchTerm(new StringBuffer(q.getTerm()), q.getMatchingRule());
            expression = Expression.like((String)hqlField, (Object)term.toString());
        } else {
            expression = Expression.eq((String)hqlField, (Object)q.getTerm());
        }
        return expression;
    }

    private Criteria getBaseCriteria(Query query, Session session) {
        Criteria baseCriteria = null;
        if (query instanceof UserQuery) {
            baseCriteria = session.createCriteria(class$com$atlassian$user$impl$hibernate$DefaultHibernateUser == null ? (class$com$atlassian$user$impl$hibernate$DefaultHibernateUser = HibernateEntityQueryParser.class$("com.atlassian.user.impl.hibernate.DefaultHibernateUser")) : class$com$atlassian$user$impl$hibernate$DefaultHibernateUser);
        } else if (query instanceof GroupQuery) {
            baseCriteria = session.createCriteria(class$com$atlassian$user$impl$hibernate$DefaultHibernateGroup == null ? (class$com$atlassian$user$impl$hibernate$DefaultHibernateGroup = HibernateEntityQueryParser.class$("com.atlassian.user.impl.hibernate.DefaultHibernateGroup")) : class$com$atlassian$user$impl$hibernate$DefaultHibernateGroup);
        } else if (query instanceof UsersInGroupTwoTermQuery) {
            baseCriteria = session.createCriteria(class$com$atlassian$user$impl$hibernate$DefaultHibernateUser == null ? (class$com$atlassian$user$impl$hibernate$DefaultHibernateUser = HibernateEntityQueryParser.class$("com.atlassian.user.impl.hibernate.DefaultHibernateUser")) : class$com$atlassian$user$impl$hibernate$DefaultHibernateUser);
        } else if (query instanceof GroupsOfUserTwoTermQuery || query instanceof GroupsOfExternalEntityTwoTermQuery) {
            baseCriteria = session.createCriteria(class$com$atlassian$user$impl$hibernate$DefaultHibernateGroup == null ? (class$com$atlassian$user$impl$hibernate$DefaultHibernateGroup = HibernateEntityQueryParser.class$("com.atlassian.user.impl.hibernate.DefaultHibernateGroup")) : class$com$atlassian$user$impl$hibernate$DefaultHibernateGroup);
        } else if (query instanceof ExternalEntitiesInGroupTwoTermQuery) {
            baseCriteria = session.createCriteria(class$com$atlassian$user$impl$hibernate$DefaultHibernateExternalEntity == null ? (class$com$atlassian$user$impl$hibernate$DefaultHibernateExternalEntity = HibernateEntityQueryParser.class$("com.atlassian.user.impl.hibernate.DefaultHibernateExternalEntity")) : class$com$atlassian$user$impl$hibernate$DefaultHibernateExternalEntity);
        }
        return baseCriteria;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

