/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.ldap.adaptor;

import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.impl.RepositoryException;
import com.atlassian.user.impl.ldap.LDAPEntity;
import com.atlassian.user.impl.ldap.LDAPGroupFactory;
import com.atlassian.user.impl.ldap.LDAPUserFactory;
import com.atlassian.user.impl.ldap.adaptor.AbstractLDAPGroupAdaptor;
import com.atlassian.user.impl.ldap.repository.LDAPRepository;
import com.atlassian.user.impl.ldap.search.DefaultLDAPUserAdaptor;
import com.atlassian.user.impl.ldap.search.LDAPPagerInfo;
import com.atlassian.user.impl.ldap.search.LDAPUserAdaptor;
import com.atlassian.user.impl.ldap.search.page.LDAPEntityPager;
import com.atlassian.user.impl.ldap.search.page.LDAPMembershipToUsernamePager;
import com.atlassian.user.search.page.Pager;
import com.atlassian.util.profiling.UtilTimerStack;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import org.apache.log4j.Logger;

public class LDAPStaticGroupAdaptor
extends AbstractLDAPGroupAdaptor {
    private static final Logger log = Logger.getLogger((Class)(class$com$atlassian$user$impl$ldap$adaptor$LDAPStaticGroupAdaptor == null ? (class$com$atlassian$user$impl$ldap$adaptor$LDAPStaticGroupAdaptor = LDAPStaticGroupAdaptor.class$("com.atlassian.user.impl.ldap.adaptor.LDAPStaticGroupAdaptor")) : class$com$atlassian$user$impl$ldap$adaptor$LDAPStaticGroupAdaptor));
    private LDAPUserAdaptor userAdaptor;
    private LDAPUserFactory userFactory;
    static /* synthetic */ Class class$com$atlassian$user$impl$ldap$adaptor$LDAPStaticGroupAdaptor;
    static /* synthetic */ Class class$com$atlassian$user$impl$ldap$LDAPEntity;

    public LDAPStaticGroupAdaptor(LDAPRepository repository, LDAPGroupFactory groupFactory, LDAPUserFactory userFactory) {
        super(repository, groupFactory);
        this.userAdaptor = new DefaultLDAPUserAdaptor(repository);
        this.userFactory = userFactory;
    }

    public Pager getGroups(User user) throws EntityException {
        LDAPPagerInfo info = this.getGroupEntriesViaMembership(user);
        if (info == null) {
            return null;
        }
        return new LDAPEntityPager(this.repository, this.groupFactory, info);
    }

    public Pager findMembers(Group group) throws EntityException {
        LDAPPagerInfo info = this.getGroupEntries(group.getName(), new String[]{this.repository.getMembershipAttribute()}, null);
        return new LDAPMembershipToUsernamePager(this.repository, info);
    }

    public Pager findMemberNames(Group group) throws EntityException {
        LDAPPagerInfo info = this.getGroupEntries(group.getName(), new String[]{this.repository.getMembershipAttribute()}, null);
        return new LDAPMembershipToUsernamePager(this.repository, info);
    }

    public boolean hasStaticGroups() {
        return true;
    }

    public boolean hasMembership(Group group, User user) throws RepositoryException {
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_hasMembership(" + group + ", " + user + ")"));
        }
        LDAPPagerInfo ldapPagerInfo = this.getGroupEntries(group.getName(), new String[]{this.repository.getGroupnameAttribute(), this.repository.getMembershipAttribute()}, null);
        while (ldapPagerInfo.getNamingEnumeration().hasMoreElements()) {
            SearchResult result = (SearchResult)ldapPagerInfo.getNamingEnumeration().nextElement();
            Attributes attrs = result.getAttributes();
            Attribute attr = attrs.get(this.repository.getMembershipAttribute());
            try {
                NamingEnumeration<?> membershipEnume = attr.getAll();
                while (membershipEnume.hasMoreElements()) {
                    String firstPhrase = this.getFirstPhraseFromDN((String)membershipEnume.nextElement());
                    if (!firstPhrase.equals(user.getName())) continue;
                    return true;
                }
            }
            catch (Exception e) {
                log.error((Object)"Error when examining getGroupEntries results from LDAP query for groups", (Throwable)e);
            }
        }
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_hasMembership(" + group + ", " + user + ")"));
        }
        return false;
    }

    public LDAPPagerInfo getGroupEntriesViaMembership(User user) throws EntityException {
        if (!(user instanceof LDAPEntity)) {
            log.info((Object)("Membership check for a non " + (class$com$atlassian$user$impl$ldap$LDAPEntity == null ? (class$com$atlassian$user$impl$ldap$LDAPEntity = LDAPStaticGroupAdaptor.class$("com.atlassian.user.impl.ldap.LDAPEntity")) : class$com$atlassian$user$impl$ldap$LDAPEntity).getName()));
            return this.getGroupEntriesViaMembership(user.getName());
        }
        LDAPEntity entity = (LDAPEntity)((Object)user);
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_getLDAPGroupEntriesViaLDAPUser(" + user.getName() + ")"));
        }
        String searchTerm = null;
        LDAPPagerInfo ldapGroupPagerInfo = null;
        try {
            String[] attributesToReturn = new String[]{this.repository.getGroupnameAttribute()};
            searchTerm = "(" + this.repository.getMembershipAttribute() + "=" + entity.getDistinguishedName() + ")";
            ldapGroupPagerInfo = this.getGroupEntries(attributesToReturn, searchTerm);
        }
        catch (RepositoryException e) {
            throw new RepositoryException(e);
        }
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_getLDAPGroupEntriesViaLDAPUser(" + user.getName() + ")"));
        }
        return ldapGroupPagerInfo;
    }

    public LDAPPagerInfo getGroupEntriesViaMembership(String userSearchPattern) throws EntityException {
        return this.getGroupEntriesViaMembership(userSearchPattern, null);
    }

    public LDAPPagerInfo getGroupEntriesViaMembership(String userSearchPattern, String[] attributesToReturn) throws EntityException {
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_getLDAPGroupEntriesViaMembership(" + userSearchPattern + ")"));
        }
        String searchTerm = null;
        LDAPPagerInfo ldapGroupPagerInfo = null;
        try {
            if (attributesToReturn == null) {
                attributesToReturn = new String[]{this.repository.getGroupnameAttribute()};
            }
            searchTerm = "(" + this.repository.getMembershipAttribute() + "=" + this.userAdaptor.getUserDN(userSearchPattern) + ")";
            ldapGroupPagerInfo = this.getGroupEntries(attributesToReturn, searchTerm);
        }
        catch (RepositoryException e) {
            throw new RepositoryException(e);
        }
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_getLDAPGroupEntriesViaMembership(" + userSearchPattern + ")"));
        }
        return ldapGroupPagerInfo;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

