/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.ldap.repository;

import com.atlassian.user.impl.RepositoryException;
import com.atlassian.user.repository.Repository;
import java.util.Hashtable;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;

public interface LDAPRepository
extends Repository {
    public static final int DEFAULT_BATCH_SIZE = 1000;
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String SECURITY_PRINCIPAL = "securityPrincipal";
    public static final String SECURITY_CREDENTIAL = "securityCredential";
    public static final String SECURITY_AUTHENTICATION = "securityAuthentication";
    public static final String PROVIDER_URL = "providerURL";
    public static final String JNDI_INITIAL_CONTEXT_FACTORY = "initialContextFactory";
    public static final String BATCH_SIZE = "batchSize";
    public static final String SECURITY_PROTOCOL = "securityProtocol";
    public static final String TIME_TO_LIVE = "timeToLive";
    public static final String BASE_USER_NAMESPACE = "baseUserNamespace";
    public static final String BASE_GROUP_NAMESPACE = "baseGroupNamespace";
    public static final String USERNAME_ATTRIBUTE = "usernameAttribute";
    public static final String GROUPNAME_ATTRIBUTE = "groupnameAttribute";
    public static final String FIRSTNAME_ATTRIBUTE = "firstnameAttribute";
    public static final String PASSWORD_ATTRIBUTE = "passwordAttribute";
    public static final String SURNAME_ATTRIBUTE = "surnameAttribute";
    public static final String EMAIL_ATTRIBUTE = "emailAttribute";
    public static final String MEMBERSHIP_ATTRIBUTE = "membershipAttribute";
    public static final String USER_SEARCH_ALL_DEPTHS = "userSearchAllDepths";
    public static final String GROUP_SEARCH_ALL_DEPTHS = "groupSearchAllDepths";
    public static final String GROUP_SEARCH_FILTER = "groupSearchFilter";
    public static final String USER_SEARCH_FILTER = "userSearchFilter";

    public int getPort();

    public String getHost();

    public String getSecurityPrincipal();

    public String getSecurityCredential();

    public Hashtable getJNDIEnv();

    public String getProviderURL();

    public String getJNDIInitialContextFactoryIdentifier();

    public String getSearchBatchSize();

    public String getSecurityAuthentication();

    public String getSecurityProtocol();

    public String getBaseUserNamespace();

    public String getBaseGroupNamespace();

    public String getUsernameAttribute();

    public String getGroupnameAttribute();

    public String getFirstnameAttribute();

    public String getSurnameAttribute();

    public String getEmailAttribute();

    public String getMembershipAttribute();

    public boolean isUserSearchScopeAllDepths();

    public boolean isGroupSearchScopeAllDepths();

    public String getGroupSearchFilter();

    public String getUserSearchFilter();

    public DirContext getLDAPContext() throws RepositoryException;

    public boolean hasStaticGroupStructure();

    public String getPasswordAttribute();

    public boolean isPoolingOn();

    public int getTimeToLive();

    public SearchControls getUserSearchControls(String[] var1);

    public SearchControls getGroupSearchControls(String[] var1);
}

