/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.ldap.search;

import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.impl.RepositoryException;
import com.atlassian.user.impl.ldap.LDAPEntity;
import com.atlassian.user.impl.ldap.repository.LDAPRepository;
import com.atlassian.user.impl.ldap.search.LDAPPagerInfo;
import com.atlassian.user.impl.ldap.search.LDAPUserAdaptor;
import com.atlassian.util.profiling.UtilTimerStack;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.log4j.Logger;

public class DefaultLDAPUserAdaptor
implements LDAPUserAdaptor {
    private static final Logger log = Logger.getLogger((Class)(class$com$atlassian$user$impl$ldap$search$DefaultLDAPUserAdaptor == null ? (class$com$atlassian$user$impl$ldap$search$DefaultLDAPUserAdaptor = DefaultLDAPUserAdaptor.class$("com.atlassian.user.impl.ldap.search.DefaultLDAPUserAdaptor")) : class$com$atlassian$user$impl$ldap$search$DefaultLDAPUserAdaptor));
    private final LDAPRepository repository;
    private String[] defaultAttributesToReturn = null;
    static /* synthetic */ Class class$com$atlassian$user$impl$ldap$search$DefaultLDAPUserAdaptor;

    public DefaultLDAPUserAdaptor(LDAPRepository repository) {
        this.repository = repository;
    }

    private String[] getDefaultAttributes() {
        if (this.defaultAttributesToReturn != null) {
            return this.defaultAttributesToReturn;
        }
        this.defaultAttributesToReturn = this.defaultAttributesToReturn == null && this.repository.getPasswordAttribute() != null ? new String[5] : new String[4];
        this.defaultAttributesToReturn[0] = this.repository.getUsernameAttribute();
        this.defaultAttributesToReturn[1] = this.repository.getFirstnameAttribute();
        this.defaultAttributesToReturn[2] = this.repository.getSurnameAttribute();
        this.defaultAttributesToReturn[3] = this.repository.getEmailAttribute();
        if (this.repository.getPasswordAttribute() != null) {
            this.defaultAttributesToReturn[4] = this.repository.getPasswordAttribute();
        }
        return this.defaultAttributesToReturn;
    }

    public LDAPPagerInfo search(String searchFilter) throws RepositoryException {
        LDAPPagerInfo ldapPagerInfo = this.search(searchFilter, this.getDefaultAttributes());
        return ldapPagerInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LDAPPagerInfo search(String searchFilter, String[] attributesToReturnFromSearch) throws RepositoryException {
        DirContext ctx = null;
        SearchControls ctls = this.repository.getUserSearchControls(attributesToReturnFromSearch);
        NamingEnumeration<SearchResult> userSearchEnume = null;
        String finalSearchFilter = searchFilter;
        if (this.repository.getUserSearchFilter() != null && searchFilter.indexOf(this.repository.getUserSearchFilter()) == -1) {
            finalSearchFilter = this.addSearchTermToFilter(new StringBuffer(searchFilter), this.repository.getUserSearchFilter()).toString();
        }
        try {
            try {
                ctx = this.repository.getLDAPContext();
                if (UtilTimerStack.isActive()) {
                    UtilTimerStack.push((String)(this.getClass().getName() + "_search_JNDI_RAW_" + finalSearchFilter));
                }
                userSearchEnume = ctx.search(this.repository.getBaseUserNamespace(), finalSearchFilter, ctls);
                if (UtilTimerStack.isActive()) {
                    UtilTimerStack.pop((String)(this.getClass().getName() + "_search_JNDI_RAW_" + finalSearchFilter));
                }
            }
            catch (NamingException e) {
                e.printStackTrace();
                throw new RepositoryException(e);
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            try {
                if (ctx == null) throw throwable;
                ctx.close();
                throw throwable;
            }
            catch (NamingException e) {
                log.error((Object)e.getMessage());
                throw new RepositoryException(e);
            }
        }
        try {}
        catch (NamingException e) {
            log.error((Object)e.getMessage());
            throw new RepositoryException(e);
        }
        if (ctx == null) return new LDAPPagerInfo(userSearchEnume, finalSearchFilter.toString(), this.repository.getBaseUserNamespace(), this.repository.isUserSearchScopeAllDepths(), attributesToReturnFromSearch);
        ctx.close();
        return new LDAPPagerInfo(userSearchEnume, finalSearchFilter.toString(), this.repository.getBaseUserNamespace(), this.repository.isUserSearchScopeAllDepths(), attributesToReturnFromSearch);
    }

    public LDAPPagerInfo getUserAttributes(String username, String[] specifiedAttributes) throws RepositoryException {
        StringBuffer query = new StringBuffer();
        query.append("(" + this.repository.getUsernameAttribute() + "=" + username + ")");
        String searchTerm = query.toString();
        if (this.repository.getUserSearchFilter() != null && !this.repository.getUserSearchFilter().equals("")) {
            searchTerm = this.addSearchTermToFilter(query, this.repository.getUserSearchFilter()).toString();
        }
        return this.search(searchTerm, specifiedAttributes);
    }

    public String getUserDN(User user) throws EntityException {
        if (user instanceof LDAPEntity) {
            LDAPEntity entity = (LDAPEntity)((Object)user);
            return entity.getDistinguishedName();
        }
        return this.getUserDN(user.getName());
    }

    public String getUserDN(String userSearchPattern) throws EntityException {
        LDAPPagerInfo ldapPagerInfo;
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_getUserDN(" + userSearchPattern + ")"));
        }
        if ((ldapPagerInfo = this.getUserAttributes(userSearchPattern, this.getDefaultAttributes())).getNamingEnumeration().hasMoreElements()) {
            SearchResult result = (SearchResult)ldapPagerInfo.getNamingEnumeration().nextElement();
            String userDN = result.getName();
            if (userDN.indexOf(this.repository.getBaseUserNamespace()) == -1) {
                userDN = userDN + "," + this.repository.getBaseUserNamespace();
            }
            try {
                ldapPagerInfo.getNamingEnumeration().close();
            }
            catch (NamingException e) {
                throw new EntityException(e);
            }
            if (UtilTimerStack.isActive()) {
                UtilTimerStack.pop((String)(this.getClass().getName() + "_getUserDN(" + userSearchPattern + ")"));
            }
            return userDN;
        }
        throw new RepositoryException("Could not locate a DN for user [" + userSearchPattern + "]");
    }

    public StringBuffer addSearchTermToFilter(StringBuffer firstTerm, String addedFilter) {
        firstTerm = firstTerm != null ? (addedFilter.indexOf("(") == 0 && addedFilter.lastIndexOf(")") == addedFilter.length() - 1 ? new StringBuffer("(&" + firstTerm + addedFilter + ")") : new StringBuffer("(&" + firstTerm + "(" + addedFilter + "))")) : new StringBuffer(addedFilter);
        return firstTerm;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

