/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.ldap.security.authentication;

import com.atlassian.user.EntityException;
import com.atlassian.user.impl.ldap.repository.LDAPRepository;
import com.atlassian.user.impl.ldap.search.DefaultLDAPUserAdaptor;
import com.atlassian.user.impl.ldap.search.LDAPUserAdaptor;
import com.atlassian.user.repository.Repository;
import com.atlassian.user.security.authentication.Authenticator;
import com.atlassian.util.profiling.UtilTimerStack;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.log4j.Logger;

public class DefaultLDAPAuthenticator
implements Authenticator {
    public static final SearchControls DEFAULT_SEARCH_CONTROLS = new SearchControls();
    private static final Logger log = Logger.getLogger((Class)(class$com$atlassian$user$impl$ldap$security$authentication$DefaultLDAPAuthenticator == null ? (class$com$atlassian$user$impl$ldap$security$authentication$DefaultLDAPAuthenticator = DefaultLDAPAuthenticator.class$("com.atlassian.user.impl.ldap.security.authentication.DefaultLDAPAuthenticator")) : class$com$atlassian$user$impl$ldap$security$authentication$DefaultLDAPAuthenticator));
    private final LDAPRepository repository;
    private final LDAPUserAdaptor userAdaptor;
    static /* synthetic */ Class class$com$atlassian$user$impl$ldap$security$authentication$DefaultLDAPAuthenticator;

    public DefaultLDAPAuthenticator(LDAPRepository repository) {
        this.repository = repository;
        this.userAdaptor = new DefaultLDAPUserAdaptor(repository);
        DEFAULT_SEARCH_CONTROLS.setReturningAttributes(new String[0]);
        DEFAULT_SEARCH_CONTROLS.setSearchScope(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticate(String username, String password) throws EntityException {
        if (password == null || password.equals("")) {
            return false;
        }
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_authenticate__" + username));
        }
        String userDN = null;
        Context ctx = null;
        try {
            userDN = this.userAdaptor.getUserDN(username);
            ctx = this.repository.getLDAPContext();
            ctx.removeFromEnvironment("java.naming.security.principal");
            ctx.removeFromEnvironment("java.naming.security.credentials");
            ctx.addToEnvironment("java.naming.security.principal", userDN);
            ctx.addToEnvironment("java.naming.security.credentials", password);
            String[] attrIDs = new String[]{this.repository.getUsernameAttribute()};
            SearchControls ctls = new SearchControls();
            ctls.setReturningAttributes(attrIDs);
            ctls.setSearchScope(2);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Doing initial search to complete authentication: username='" + username + "', password='" + password + "', base='" + this.repository.getBaseUserNamespace()));
            }
            NamingEnumeration<SearchResult> results = ctx.search(this.repository.getBaseUserNamespace(), this.repository.getUsernameAttribute() + "=" + username, ctls);
            if (log.isDebugEnabled()) {
                if (results != null && results.hasMore()) {
                    log.debug((Object)"Users found.");
                } else {
                    log.debug((Object)"No users found");
                }
            }
        }
        catch (NamingException e) {
            log.error((Object)("Authentication error: " + e.getMessage()));
            boolean bl = false;
            return bl;
        }
        catch (Throwable t) {
            log.error((Object)("Error occurred in LDAP authentication for username: " + username), t);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                ctx.close();
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
        }
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_authenticate__" + username));
        }
        return true;
    }

    public Repository getRepository() {
        return this.repository;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

