/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.osuser;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.impl.DuplicateEntityException;
import com.atlassian.user.impl.RepositoryException;
import com.atlassian.user.impl.osuser.OSUAccessor;
import com.atlassian.user.impl.osuser.OSUEntityManager;
import com.atlassian.user.impl.osuser.OSUUser;
import com.atlassian.user.properties.PropertySetFactory;
import com.atlassian.user.repository.Repository;
import com.atlassian.user.search.EntityNameAlphaComparator;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.security.authentication.Authenticator;
import com.atlassian.user.security.password.PasswordEncryptor;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.user.ImmutableException;
import com.opensymphony.user.ManagerAccessor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class OSUUserManager
extends OSUEntityManager
implements UserManager,
PropertySetFactory {
    private static final Logger log = Logger.getLogger((Class)(class$com$atlassian$user$impl$osuser$OSUUserManager == null ? (class$com$atlassian$user$impl$osuser$OSUUserManager = OSUUserManager.class$("com.atlassian.user.impl.osuser.OSUUserManager")) : class$com$atlassian$user$impl$osuser$OSUUserManager));
    private OSUAccessor accessor;
    private Authenticator authenticator;
    static /* synthetic */ Class class$com$atlassian$user$impl$osuser$OSUUserManager;

    public OSUUserManager(Repository repository, OSUAccessor accessor) throws EntityException {
        super(repository);
        this.accessor = accessor;
    }

    public Pager getUsers() {
        List userNames = this.accessor.getCredentialsProvider().list();
        TreeSet<OSUUser> atlassianUsers = new TreeSet<OSUUser>(EntityNameAlphaComparator.getInstance());
        Iterator iterator = userNames.iterator();
        while (iterator.hasNext()) {
            com.opensymphony.user.User u = new com.opensymphony.user.User((String)iterator.next(), (ManagerAccessor)this.accessor);
            atlassianUsers.add(new OSUUser(u));
        }
        return new DefaultPager(atlassianUsers);
    }

    public Pager getUserNames() throws EntityException {
        return new DefaultPager(this.accessor.getCredentialsProvider().list());
    }

    public User getUser(String username) {
        if (this.accessor.getCredentialsProvider().handles(username)) {
            return new OSUUser(new com.opensymphony.user.User(username, (ManagerAccessor)this.accessor));
        }
        return null;
    }

    private com.opensymphony.user.User getOpensymphonyUser(String username) {
        return new com.opensymphony.user.User(username, (ManagerAccessor)this.accessor);
    }

    public User createUser(String username) throws EntityException {
        if (this.accessor.getCredentialsProvider().handles(username)) {
            throw new DuplicateEntityException("User [" + username + "] already exists in credentialsProvider [" + this.accessor.getCredentialsProvider().toString() + "]");
        }
        if (this.accessor.getCredentialsProvider().create(username)) {
            this.accessor.getProfileProvider().create(username);
            return new OSUUser(new com.opensymphony.user.User(username, (ManagerAccessor)this.accessor));
        }
        throw new EntityException("Was unable to create user [" + username + "] but the credentials provider [" + this.accessor.getCredentialsProvider().toString() + "] did not say why.");
    }

    public void alterPassword(User user, String plainTextPass) throws EntityException {
        user.setPassword(plainTextPass);
        this.saveUser(user);
    }

    public void removeUser(User user) throws EntityException {
        if (user == null) {
            throw new IllegalArgumentException("Cannot remove a null user: [" + user + "]");
        }
        if (!(user instanceof OSUUser)) {
            throw new IllegalArgumentException("User is not a OSUUser [" + user.getClass().getName());
        }
        ArrayList groupsOfUser = this.accessor.getAccessProvider().listGroupsContainingUser(user.getName());
        groupsOfUser = new ArrayList(groupsOfUser);
        int i = 0;
        for (i = 0; i < groupsOfUser.size(); ++i) {
            String groupName = (String)groupsOfUser.get(i);
            this.accessor.getAccessProvider().removeFromGroup(user.getName(), groupName);
        }
        boolean result = this.accessor.getCredentialsProvider().remove(user.getName());
        if (!result) {
            throw new EntityException("Could not remove user!");
        }
        this.accessor.getProfileProvider().remove(user.getName());
    }

    public boolean isReadOnly(User user) {
        return this.getUser(user.getName()) == null;
    }

    public PasswordEncryptor getPasswordEncryptor(User user) throws EntityException {
        if (this.getUser(user.getName()) != null) {
            throw new UnsupportedOperationException("OSUser does not make available its encryptor for access. Check your configuration.The standard OSUPasswordEncryptor could do what you need, if you are using a vanilla OSUser configuration.");
        }
        return null;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public void saveUser(User user) throws EntityException {
        com.opensymphony.user.User osUser = this.getOpensymphonyUser(user.getName());
        osUser.setEmail(user.getEmail());
        try {
            osUser.store();
        }
        catch (ImmutableException e) {
            throw new RepositoryException(e);
        }
    }

    public PropertySet getPropertySet(Entity entity) {
        PropertySet propertySet = null;
        if (!(entity instanceof User)) {
            return null;
        }
        propertySet = this.accessor.getProfileProvider().getPropertySet(entity.getName());
        if (propertySet == null && this.getUser(entity.getName()) != null) {
            this.accessor.getProfileProvider().create(entity.getName());
            propertySet = this.accessor.getProfileProvider().getPropertySet(entity.getName());
        }
        return propertySet;
    }

    public void setAccessor(OSUAccessor accessor) {
        this.accessor = accessor;
    }

    public Repository getRepository(Entity entity) throws EntityException {
        if (this.getUser(entity.getName()) != null) {
            return this.repository;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

