/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.osuser.config.xml;

import com.atlassian.user.impl.osuser.DefaultOSUAccessor;
import com.atlassian.user.impl.osuser.config.xml.DefaultOSUConfigurationHandler;
import com.atlassian.user.impl.osuser.config.xml.OSUConfigurationLoader;
import com.atlassian.user.repository.Repository;
import com.opensymphony.user.provider.AccessProvider;
import com.opensymphony.user.provider.CredentialsProvider;
import com.opensymphony.user.provider.ProfileProvider;
import com.opensymphony.user.provider.UserProvider;
import com.opensymphony.util.ClassLoaderUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultOSUConfigurationLoader
implements OSUConfigurationLoader {
    private static final Logger log = Logger.getLogger((Class)(class$com$atlassian$user$impl$osuser$config$xml$DefaultOSUConfigurationLoader == null ? (class$com$atlassian$user$impl$osuser$config$xml$DefaultOSUConfigurationLoader = DefaultOSUConfigurationLoader.class$("com.atlassian.user.impl.osuser.config.xml.DefaultOSUConfigurationLoader")) : class$com$atlassian$user$impl$osuser$config$xml$DefaultOSUConfigurationLoader));
    protected Repository config;
    protected DefaultOSUConfigurationHandler configHandler;
    protected DefaultOSUAccessor accessor;
    protected ProfileProvider profileProvider;
    protected AccessProvider accessProvider;
    protected CredentialsProvider credentialsProvider;
    static /* synthetic */ Class class$com$atlassian$user$impl$osuser$config$xml$DefaultOSUConfigurationLoader;

    public DefaultOSUConfigurationLoader() {
    }

    public DefaultOSUConfigurationLoader(DefaultOSUAccessor accessor) {
        this.accessor = accessor;
    }

    public synchronized void load(InputStream in) {
        log.debug((Object)"Loading config");
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(in, this.getOSUserConfigurationHandler());
        }
        catch (SAXException e) {
            log.error((Object)"Could not parse config XML", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
        catch (IOException e) {
            log.error((Object)"Could not read config from stream", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            log.fatal((Object)"Could not obtain SAX parser", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
        catch (RuntimeException e) {
            log.fatal((Object)"RuntimeException", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            log.fatal((Object)"Exception", e);
            throw new RuntimeException(e.getMessage());
        }
    }

    public DefaultHandler getOSUserConfigurationHandler() {
        if (this.configHandler == null) {
            this.configHandler = new DefaultOSUConfigurationHandler(this);
        }
        return this.configHandler;
    }

    public void setOSUserConfigurationHandler(DefaultOSUConfigurationHandler configHandler) {
        this.configHandler = configHandler;
    }

    public void addProvider(String providerClassName, Properties providerProperties) {
        block11: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("UserProvider class = " + providerClassName + " " + providerProperties));
            }
            try {
                UserProvider provider = (UserProvider)ClassLoaderUtil.loadClass((String)providerClassName, this.getClass()).newInstance();
                if (provider == null) {
                    log.error((Object)("OSUser provider class was unable to be instantiated: [" + providerClassName + "]"));
                }
                if (provider.init(providerProperties)) {
                    if (provider instanceof AccessProvider) {
                        if (this.accessor != null) {
                            this.accessor.setAccessProvider((AccessProvider)provider);
                        }
                        this.accessProvider = (AccessProvider)provider;
                    }
                    if (provider instanceof CredentialsProvider) {
                        if (this.accessor != null) {
                            this.accessor.setCredentialsProvider((CredentialsProvider)provider);
                        }
                        this.credentialsProvider = (CredentialsProvider)provider;
                    }
                    if (provider instanceof ProfileProvider) {
                        if (this.accessor != null) {
                            this.accessor.setProfileProvider((ProfileProvider)provider);
                        }
                        this.profileProvider = (ProfileProvider)provider;
                    }
                    break block11;
                }
                log.error((Object)("Could not getConnectionPoolProperties provider " + providerClassName));
                throw new RuntimeException("Could not getConnectionPoolProperties provider " + providerClassName);
            }
            catch (Exception e) {
                log.error((Object)"Could not create instance of provider", (Throwable)e);
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    public void setAccessor(DefaultOSUAccessor accessor) {
        this.accessor = accessor;
    }

    public DefaultOSUAccessor getAccessor() {
        return this.accessor;
    }

    public ProfileProvider getProfileProvider() {
        return this.profileProvider;
    }

    public AccessProvider getAccessProvider() {
        return this.accessProvider;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

