/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.osuser.security.authentication;

import com.atlassian.user.EntityException;
import com.atlassian.user.repository.Repository;
import com.atlassian.user.security.authentication.EntityAuthenticationException;
import com.opensymphony.user.authenticator.AuthenticationException;
import com.opensymphony.user.authenticator.Authenticator;
import com.opensymphony.user.provider.CredentialsProvider;

public class OSUAuthenticator
implements com.atlassian.user.security.authentication.Authenticator {
    private final Repository repository;
    private Authenticator osuserAuthenticator;
    private CredentialsProvider credentialsProvider;
    boolean wrappingCredentialProvider;

    public OSUAuthenticator(Repository repository, CredentialsProvider credentialsProvider) {
        this.repository = repository;
        this.wrappingCredentialProvider = true;
        this.credentialsProvider = credentialsProvider;
    }

    public OSUAuthenticator(Repository repository, Authenticator wrappedAuthenticator) {
        this.repository = repository;
        this.osuserAuthenticator = wrappedAuthenticator;
    }

    public boolean authenticate(String username, String password) throws EntityException {
        boolean result = false;
        if (this.isWrappingCredentialProvider()) {
            result = this.credentialsProvider.authenticate(username, password);
        } else {
            try {
                result = this.osuserAuthenticator.login(username, password);
            }
            catch (AuthenticationException e) {
                throw new EntityAuthenticationException(e);
            }
        }
        return result;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public boolean isWrappingCredentialProvider() {
        return this.wrappingCredentialProvider;
    }
}

