/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.util;

import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.impl.DefaultUser;
import com.atlassian.user.impl.RepositoryException;
import com.atlassian.user.impl.ldap.DefaultLDAPGroupFactory;
import com.atlassian.user.impl.ldap.LDAPGroupManagerReadOnly;
import com.atlassian.user.impl.ldap.LDAPUserManagerReadOnly;
import com.atlassian.user.impl.ldap.PasswordCarriedLDAPUserFactory;
import com.atlassian.user.impl.ldap.adaptor.LDAPDynamicGroupAdaptor;
import com.atlassian.user.impl.ldap.adaptor.LDAPGroupAdaptor;
import com.atlassian.user.impl.ldap.adaptor.LDAPStaticGroupAdaptor;
import com.atlassian.user.impl.ldap.repository.LDAPRepository;
import com.atlassian.user.impl.ldap.search.query.LDAPEntityQueryParser;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.util.LDAPConfigurationBuilder;
import com.atlassian.user.util.RPCUtils;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;

public class ConfluenceLDAPImporter {
    String baseUrl;
    String adminToken;
    protected XmlRpcClient xmlrpc;
    protected String username;
    protected String password;
    private LDAPUserManagerReadOnly userManager;
    private LDAPGroupManagerReadOnly groupManager;
    private LDAPRepository ldapRepository;
    private LDAPEntityQueryParser queryParser;
    public LDAPGroupAdaptor groupAdaptor;

    public ConfluenceLDAPImporter() {
        try {
            this.baseUrl = System.getProperty("baseUrl");
            this.username = System.getProperty("adminUsername");
            this.password = System.getProperty("adminPassword");
            this.ldapRepository = LDAPConfigurationBuilder.getStandaloneLDAPConfiguration();
            PasswordCarriedLDAPUserFactory userFactory = new PasswordCarriedLDAPUserFactory(this.ldapRepository);
            DefaultLDAPGroupFactory groupFactory = new DefaultLDAPGroupFactory(this.ldapRepository);
            this.groupAdaptor = this.ldapRepository.hasStaticGroupStructure() ? new LDAPStaticGroupAdaptor(this.ldapRepository, groupFactory, userFactory) : new LDAPDynamicGroupAdaptor(this.ldapRepository, groupFactory, userFactory);
            this.queryParser = new LDAPEntityQueryParser(this.ldapRepository, this.groupAdaptor, userFactory);
            this.userManager = new LDAPUserManagerReadOnly(this.ldapRepository, this.queryParser);
            this.groupManager = new LDAPGroupManagerReadOnly(this.ldapRepository, this.groupAdaptor);
            this.xmlrpc = new XmlRpcClient(this.baseUrl + "/rpc/xmlrpc");
            Pager groupsPager = this.groupManager.getGroups();
            Iterator groupsIter = groupsPager.iterator();
            while (groupsIter.hasNext()) {
                Group group = (Group)groupsIter.next();
                this.importGroup(group);
            }
            Pager userPager = this.userManager.getUsers();
            Iterator userIter = userPager.iterator();
            User u = null;
            while (userIter.hasNext()) {
                u = (User)userIter.next();
                DefaultUser u2 = (DefaultUser)u;
                this.importUser(u2);
            }
            System.out.println(u);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (EntityException e) {
            e.printStackTrace();
        }
    }

    private void importGroup(Group g) {
        try {
            this.xmlrpc.execute("confluence1.addGroup", RPCUtils.makeParams(this.getAdminToken(), g.getName()));
            System.out.println("Successfully imported group [" + g.getName() + "]");
        }
        catch (Exception e) {
            System.out.println("Could not import group [" + g.getName() + "]:" + e.getMessage());
        }
    }

    private void importUser(DefaultUser u) {
        try {
            Hashtable<String, String> ht = new Hashtable<String, String>();
            ht.put("name", u.getName());
            ht.put("email", u.getEmail());
            ht.put("fullname", u.getFullName());
            if (u.getPassword() == null) {
                System.out.println("null password");
            }
            this.xmlrpc.execute("confluence1.addUser", RPCUtils.makeParams(this.getAdminToken(), ht, u.getPassword()));
        }
        catch (Exception e) {
            System.out.println("error importing user [" + u.getName() + "]. " + e.getMessage());
        }
        try {
            System.out.println("Successfully imported user [" + u.getName() + "]");
            System.out.println("Checking membership for [" + u.getName() + "]");
            Pager pager = this.groupManager.getGroups(u);
            Iterator iter = pager.iterator();
            if (!pager.isEmpty()) {
                while (iter.hasNext()) {
                    Group group = (Group)iter.next();
                    try {
                        this.xmlrpc.execute("confluence1.addUserToGroup", RPCUtils.makeParams(this.getAdminToken(), u.getName(), group.getName().toLowerCase()));
                        System.out.println("Added membership to [" + group + "] for [" + u + "]");
                    }
                    catch (Exception e) {
                        System.out.println("error importing membership for [" + u.getName() + "]. " + e.getMessage());
                    }
                }
                System.out.println("");
            }
        }
        catch (Exception e) {
            System.out.println("error importing user [" + u.getName() + "]. " + e.getMessage());
        }
    }

    protected String getAdminToken() throws EntityException {
        try {
            this.adminToken = (String)this.xmlrpc.execute("confluence1.login", RPCUtils.makeParams(this.username, this.password));
        }
        catch (XmlRpcException e) {
            throw new RepositoryException(e);
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        return this.adminToken;
    }

    public static void main(String[] args) {
        new ConfluenceLDAPImporter();
    }
}

