/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.api;

import com.yourkit.Constants;
import com.yourkit.api.ControllerImpl;
import com.yourkit.runtime.CaptureSnapshotRes;
import java.lang.reflect.Field;

public final class Controller {
    private final ControllerImpl myImpl;
    public static final String DEFAULT_FILTERS = "com.sun.*\njava.*\njavax.*\nsun.*\njrockit.*";

    public Controller() throws Exception {
        this("localhost", Controller.getUsedPort());
    }

    public Controller(String host, int port) throws Exception {
        Controller.checkJdk();
        this.myImpl = new ControllerImpl(host, port);
    }

    public String getHost() {
        return this.myImpl.getHost();
    }

    public int getPort() {
        return this.myImpl.getPort();
    }

    static int getUsedPort() throws Exception {
        int port = -1;
        try {
            ClassLoader loader = ClassLoader.getSystemClassLoader();
            Class<?> aClass = loader.loadClass("com.yourkit.runtime.Core");
            Field field = aClass.getDeclaredField("ourPort");
            Integer i = (Integer)field.get(null);
            port = i;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (port == -1) {
            throw new Exception("To profile application, you should run it with the profiler agent");
        }
        return port;
    }

    public String captureMemorySnapshot(boolean continueAllocationRecording) throws Exception {
        Controller.checkJdk();
        CaptureSnapshotRes result = this.myImpl.captureMemorySnapshot(continueAllocationRecording, null);
        return result.getSnapshotFilePath();
    }

    public String captureMemorySnapshot() throws Exception {
        return this.captureMemorySnapshot(false);
    }

    public String captureCPUSnapshot(boolean continueCPUProfiling) throws Exception {
        Controller.checkJdk();
        CaptureSnapshotRes result = this.myImpl.captureCPUSnapshot(continueCPUProfiling, null);
        return result.getSnapshotFilePath();
    }

    public String captureTelemetrySnapshot() throws Exception {
        Controller.checkJdk();
        CaptureSnapshotRes result = this.myImpl.captureTelemetrySnapshot(null);
        return result.getSnapshotFilePath();
    }

    public void startAllocationsRecording() throws Exception {
        this.startAllocationRecording(66L);
    }

    public void startAllocationRecording(long mode) throws Exception {
        this.myImpl.startAllocationRecording(mode);
    }

    public void stopAllocationsRecording() throws Exception {
        this.stopAllocationRecording();
    }

    public void stopAllocationRecording() throws Exception {
        this.myImpl.stopAllocationRecording();
    }

    public void startCPUProfiling(long mode, String filters) throws Exception {
        this.myImpl.startCPUProfiling(mode, filters);
    }

    public void startCPUMeasuring(boolean timesOnly) throws Exception {
        this.startCPUProfiling(timesOnly ? 4L : 12L, DEFAULT_FILTERS);
    }

    public void startCPUTimesMeasuring() throws Exception {
        this.startCPUProfiling(4L, null);
    }

    public void startCPUTimesAndCountsNoLibMeasuring() throws Exception {
        this.startCPUProfiling(12L, DEFAULT_FILTERS);
    }

    public void startCPUTimesAndCountsMeasuring() throws Exception {
        this.startCPUProfiling(12L, "");
    }

    public void stopCPUMeasuring() throws Exception {
        this.stopCPUProfiling();
    }

    public void stopCPUProfiling() throws Exception {
        this.myImpl.stopCPUProfiling();
    }

    public long[] forceGC() throws Exception {
        return this.myImpl.forceGC();
    }

    static void checkJdk() {
        if (Constants.JAVA_VERSION.compareTo("1.4") < 0) {
            throw new RuntimeException("YourKit Java Profiler API requires Java 1.4 or newer");
        }
    }
}

