/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.api;

import com.yourkit.api.TelemetryRecord2;
import com.yourkit.runtime.AgentProtocolException;
import com.yourkit.runtime.Packet;
import com.yourkit.util.Asserts;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public final class TelemetryProtocolImpl1 {
    private static final long TID_JVM_HEAP_MEMORY_USAGE = 1L;
    private static final long TID_JVM_NON_HEAP_MEMORY_USAGE = 2L;
    private static final long TID_CLASSES = 3L;
    private static final long TID_JVM_THREADS = 4L;
    private static final long TID_JVM_GARBAGE_COLLECTOR = 5L;
    private static final long TID_RUNTIME = 6L;
    private static final long TID_CLR_HEAP_MEMORY_USAGE = 7L;
    private static final long TID_CLR_GARBAGE_COLLECTOR = 8L;
    private static final long TID_CLR_CPU_TIME = 9L;
    private static final long TID_CLR_THREADS = 10L;
    private static final long TID_JVM_CPU_TIME = 11L;
    private static final long TID_JVM_DEADLOCK = 12L;

    static final void getTelemetryRecordsImpl(DataInputStream input, DataOutputStream output, long timestampMs, ArrayList result) throws IOException {
        Packet.writeHeader(output, 20000);
        Packet.writeLong(output, timestampMs);
        Packet.flush(output);
        Packet.readHeader(input, 20001);
        int recordCount = Packet.readInt(input);
        if (recordCount < 0) {
            throw new AgentProtocolException("Invalid recordsToFollow: " + recordCount);
        }
        for (int i = 0; i < recordCount; ++i) {
            Packet.readHeader(input, 20002);
            long timestamp1 = Packet.readLong(input);
            int valueCount = Packet.readInt(input);
            if (valueCount < 0) {
                throw new AgentProtocolException("Invalid valueCount: " + valueCount);
            }
            long[] values = new long[valueCount];
            for (int j = 0; j < values.length; ++j) {
                values[j] = Packet.readLong(input);
            }
            TelemetryProtocolImpl1.parseTelemetryRecords(timestamp1, values, result);
        }
    }

    public static void parseTelemetryRecords(long timestampMs, long[] values, ArrayList result) {
        Asserts.notNull(values);
        Asserts.notNull(result);
        int idx = 0;
        while (idx < values.length) {
            long cpuTimeMs;
            long createdThreadCount;
            long liveThreadCount;
            long maximum;
            long committed;
            long used;
            long init;
            long recordID;
            Asserts.assertTrue((recordID = values[idx++]) > 0L);
            long recordLength = values[idx++];
            Asserts.assertTrue(recordLength > 0L);
            if (1L == recordID) {
                init = values[idx++];
                result.add(new TelemetryRecord2(1000, timestampMs, init));
                used = values[idx++];
                result.add(new TelemetryRecord2(1001, timestampMs, used));
                committed = values[idx++];
                result.add(new TelemetryRecord2(1002, timestampMs, committed));
                maximum = values[idx++];
                result.add(new TelemetryRecord2(1003, timestampMs, maximum));
                continue;
            }
            if (2L == recordID) {
                init = values[idx++];
                result.add(new TelemetryRecord2(2000, timestampMs, init));
                used = values[idx++];
                result.add(new TelemetryRecord2(2001, timestampMs, used));
                committed = values[idx++];
                result.add(new TelemetryRecord2(2002, timestampMs, committed));
                maximum = values[idx++];
                result.add(new TelemetryRecord2(2003, timestampMs, maximum));
                continue;
            }
            if (3L == recordID) {
                int n = ++idx;
                long loadedClassCount = values[n];
                int n2 = ++idx;
                ++idx;
                long unloadedClassCount = values[n2];
                result.add(new TelemetryRecord2(3003, timestampMs, loadedClassCount));
                result.add(new TelemetryRecord2(3004, timestampMs, unloadedClassCount));
                continue;
            }
            if (4L == recordID) {
                liveThreadCount = values[idx++];
                long peakLiveThreadCount = values[idx++];
                createdThreadCount = values[idx++];
                long daemonThreadCount = values[idx++];
                result.add(new TelemetryRecord2(4000, timestampMs, liveThreadCount));
                result.add(new TelemetryRecord2(4001, timestampMs, peakLiveThreadCount));
                result.add(new TelemetryRecord2(4002, timestampMs, createdThreadCount));
                result.add(new TelemetryRecord2(4003, timestampMs, daemonThreadCount));
                continue;
            }
            if (5L == recordID) {
                long totalMinorCount = values[idx++];
                result.add(new TelemetryRecord2(5000, timestampMs, totalMinorCount));
                long totalMinorTime = values[idx++];
                long totalMajorCount = values[idx++];
                result.add(new TelemetryRecord2(5001, timestampMs, totalMajorCount));
                long totalMajorTime = values[idx++];
                result.add(new TelemetryRecord2(5002, timestampMs, totalMajorTime + totalMinorTime));
                continue;
            }
            if (11L == recordID) {
                cpuTimeMs = values[idx++];
                result.add(new TelemetryRecord2(6000, timestampMs, cpuTimeMs));
                continue;
            }
            if (12L == recordID) {
                long deadlock = values[idx++];
                result.add(new TelemetryRecord2(9000, timestampMs, deadlock));
                continue;
            }
            if (6L == recordID) {
                long processorCount = values[idx++];
                long uptimeMs = values[idx++];
                result.add(new TelemetryRecord2(7000, timestampMs, processorCount));
                result.add(new TelemetryRecord2(8000, timestampMs, uptimeMs));
                continue;
            }
            if (7L == recordID) {
                long usedHeapSize = values[idx++];
                long allocatedHeapSize = values[idx++];
                result.add(new TelemetryRecord2(100000, timestampMs, usedHeapSize));
                result.add(new TelemetryRecord2(100001, timestampMs, allocatedHeapSize));
                continue;
            }
            if (8L == recordID) {
                long totalCollectionCount = values[idx++];
                long totalCollectionTime = values[idx++];
                result.add(new TelemetryRecord2(104000, timestampMs, totalCollectionCount));
                result.add(new TelemetryRecord2(105000, timestampMs, totalCollectionTime));
                continue;
            }
            if (9L == recordID) {
                cpuTimeMs = values[idx++];
                result.add(new TelemetryRecord2(106000, timestampMs, cpuTimeMs));
                continue;
            }
            if (10L == recordID) {
                liveThreadCount = values[idx++];
                long peakThreadCount = values[idx++];
                createdThreadCount = values[idx++];
                result.add(new TelemetryRecord2(107000, timestampMs, liveThreadCount));
                result.add(new TelemetryRecord2(107001, timestampMs, peakThreadCount));
                result.add(new TelemetryRecord2(107002, timestampMs, createdThreadCount));
                continue;
            }
            idx = (int)((long)idx + recordLength);
        }
    }
}

