/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util;

import com.yourkit.Constants;
import com.yourkit.util.Asserts;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;

public final class MarkerFiles {
    public static final String AGENT_PREFIX = ".yjp_agent";
    public static final String IDE_PLUGIN_PREFIX = ".yjp_ide";
    public static final String PROFILER_UI_PREFIX = ".yjp_20060615_ui";
    public static final String IIS_PREFIX = ".ynp_iis";
    public static final File MARKERS_DIR;
    public static final String SESSION_LOG_FILENAME = ".yjp_finished_sessions";

    public static File createMarker0(String prefix, int port) throws IOException {
        Asserts.notNull(prefix);
        File marker = MarkerFiles.getMarkerFile(prefix, port);
        marker.createNewFile();
        marker.deleteOnExit();
        return marker;
    }

    public static File getMarkerFile(String prefix, int port) {
        return new File(MARKERS_DIR, prefix + port);
    }

    public static File createMarker(String prefix, int port) {
        Asserts.notNull(prefix);
        try {
            return MarkerFiles.createMarker0(prefix, port);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static File[] getMarkerFiles(final String prefix) {
        ArrayList<File> result = new ArrayList<File>();
        File[] files = MARKERS_DIR.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isFile() && file.getName().startsWith(prefix);
            }
        });
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (!file.isFile()) continue;
                result.add(file);
            }
        }
        return result.toArray(new File[result.size()]);
    }

    static {
        File alternateDir = null;
        if (Constants.OS_WINDOWS) {
            File dir = new File("c:\\windows\\temp");
            if (dir.isDirectory() && dir.canWrite()) {
                alternateDir = new File(dir, ".yjp");
            }
        } else {
            File dir = new File("/tmp");
            if (dir.isDirectory() && dir.canWrite()) {
                alternateDir = dir;
            }
        }
        MARKERS_DIR = alternateDir != null ? alternateDir : Constants.SYSTEM_HOME;
    }
}

