/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.tasklist;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.confluence.extra.tasklist.model.TaskList;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.VelocityUtils;
import com.atlassian.renderer.macro.macros.AbstractHtmlGeneratingMacro;
import com.opensymphony.webwork.ServletActionContext;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.radeox.macro.parameter.MacroParameter;

public class TaskListMacro
extends AbstractHtmlGeneratingMacro {
    ContentPropertyManager contentPropertyManager;

    protected String getHtml(MacroParameter macroParameter) throws IllegalArgumentException, IOException {
        String listName = macroParameter.get(0);
        ContentEntityObject contentObject = MacroUtils.getContentEntityObject((MacroParameter)macroParameter);
        String body = macroParameter.getContent();
        TaskList taskList = new TaskList(listName, contentObject, body, this.contentPropertyManager);
        HttpServletRequest request = ServletActionContext.getRequest();
        if (request != null) {
            String remoteUser = request.getRemoteUser();
            if (request.getParameter("tasklist.complete") != null) {
                taskList.completeTask(request.getParameter("tasklist.complete"), remoteUser);
            } else if (request.getParameter("tasklist.uncomplete") != null) {
                taskList.uncompleteTask(request.getParameter("tasklist.uncomplete"));
            }
        }
        Map contextMap = MacroUtils.defaultVelocityContext();
        contextMap.put("tasklist", taskList);
        contextMap.put("content", contentObject);
        try {
            return VelocityUtils.getRenderedTemplate((String)"templates/extra/tasklist/tasklistmacro.vm", (Map)contextMap);
        }
        catch (Exception e) {
            this.log.error((Object)"Error while trying to display TaskList!", (Throwable)e);
            throw new IOException(e.getMessage());
        }
    }

    public String getName() {
        return "tasklist";
    }

    public void setContentPropertyManager(ContentPropertyManager contentPropertyManager) {
        this.contentPropertyManager = contentPropertyManager;
    }
}

