/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.tasklist.model;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.confluence.extra.tasklist.model.Task;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.collections.SequencedHashMap;

public class TaskList {
    private final String name;
    private final ContentEntityObject content;
    private final ContentPropertyManager contentPropertyManager;
    Map tasks;

    public TaskList(String name, ContentEntityObject content, String body, ContentPropertyManager contentPropertyManager) {
        this.name = name;
        this.content = content;
        this.contentPropertyManager = contentPropertyManager;
        this.createTasks(body);
    }

    private void createTasks(String body) {
        this.tasks = new SequencedHashMap();
        StringTokenizer stringTokenizer = new StringTokenizer(body, "\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            String line = stringTokenizer.nextToken();
            Task task = new Task(line);
            String completer = this.contentPropertyManager.getStringProperty(this.content, "tasklist." + this.name + "." + line);
            if (TextUtils.stringSet((String)completer)) {
                task.setCompleter(completer);
            }
            this.tasks.put(task.getName(), task);
        }
    }

    public String getName() {
        return this.name;
    }

    public List getTasks() {
        return new ArrayList(this.tasks.values());
    }

    public void completeTask(String taskname, String username) {
        Task task = (Task)this.tasks.get(taskname);
        if (task != null) {
            if (!TextUtils.stringSet((String)username)) {
                username = "Unknown";
            }
            this.contentPropertyManager.setStringProperty(this.content, "tasklist." + this.name + "." + taskname, username);
            task.setCompleter(username);
        }
    }

    public void uncompleteTask(String taskname) {
        Task task = (Task)this.tasks.get(taskname);
        if (task != null) {
            this.contentPropertyManager.setStringProperty(this.content, "tasklist." + this.name + "." + taskname, null);
            task.setCompleter(null);
        }
    }

    public int getPercentComplete() {
        int complete = 0;
        Iterator iterator = this.getTasks().iterator();
        while (iterator.hasNext()) {
            Task task = (Task)iterator.next();
            if (!task.isCompleted()) continue;
            ++complete;
        }
        return (int)(100.0f * ((float)complete / (float)this.tasks.size()));
    }
}

