/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.ext.yourkit;

import com.atlassian.confluence.core.Administrative;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.yourkit.api.Controller;

public class ProfilingAction
extends ConfluenceActionSupport
implements Administrative {
    boolean captureSnapshot = false;

    public String execute() throws Exception {
        Controller controller = null;
        try {
            controller = new Controller();
        }
        catch (Exception e) {
            this.addActionError("Please ensure Confluence is started with the profiler libraries.");
            this.log.error((Object)("Failure to get YourKit controller - ensure profiling libraries present: " + e), (Throwable)e);
        }
        if (!this.hasErrors() && controller != null && this.captureSnapshot) {
            try {
                long start = System.currentTimeMillis();
                String location = controller.captureMemorySnapshot(false);
                this.addActionMessage("Captured snapshot (" + (System.currentTimeMillis() - start) / 1000L + "secs) to: " + location);
            }
            catch (Exception e) {
                this.addActionError("Agent failed to capture snapshot for the following reason: " + e.getMessage());
                this.log.error((Object)("Failure to capture snapshot: " + e), (Throwable)e);
            }
        }
        if (this.hasErrors()) {
            return "error";
        }
        return "success";
    }

    public boolean isCaptureSnapshot() {
        return this.captureSnapshot;
    }

    public void setCaptureSnapshot(boolean captureSnapshot) {
        this.captureSnapshot = captureSnapshot;
    }
}

