/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.api;

import com.yourkit.runtime.AgentProtocolException;
import com.yourkit.runtime.AgentReportedErrorException;
import com.yourkit.runtime.CLRInfo;
import com.yourkit.runtime.CaptureSnapshotRes;
import com.yourkit.runtime.JVMInfo;
import com.yourkit.runtime.Packet;
import com.yourkit.runtime.ProgressListener;
import com.yourkit.runtime.StackTraceElementRes;
import com.yourkit.runtime.TelemetryRecord;
import com.yourkit.runtime.ThreadInfoRes;
import com.yourkit.util.Asserts;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;

public final class ControllerImpl {
    private final String myHost;
    private final int myPort;
    private final long myInitialStatus;
    private int myInitialUsedMemoryThreshold;
    private String mySessionName;
    private String mySnapshotDir;
    private long myCapabilities;
    private JVMInfo myJVMInfo;
    private CLRInfo myCLRInfo;
    private String myJavaVersion;

    public ControllerImpl(String host, int port) throws Exception {
        if (host == null) {
            throw new IllegalArgumentException("host cannot be null");
        }
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("port must be in range 1-65535: " + port);
        }
        this.myHost = host;
        this.myPort = port;
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 3000);
                Packet.flush(output);
                Packet.readHeader(input, 3001);
                ControllerImpl.this.mySessionName = Packet.readStringNotNull(input);
            }
        });
        Asserts.notNull(this.mySessionName);
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 4000);
                Packet.flush(output);
                Packet.readHeader(input, 4001);
                ControllerImpl.this.mySnapshotDir = Packet.readStringNotNull(input);
            }
        });
        Asserts.notNull(this.mySnapshotDir);
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 19000);
                Packet.flush(output);
                Packet.readHeader(input, 19001);
                ControllerImpl.this.myJavaVersion = Packet.readStringNotNull(input);
            }
        });
        Asserts.notNull(this.myJavaVersion);
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 1000);
                Packet.flush(output);
                Packet.readHeader(input, 1001);
                ControllerImpl.this.myCapabilities = Packet.readLong(input);
            }
        });
        if ((this.myCapabilities & 0x200L) != 0L) {
            this.makeRequest(new Communication(){

                public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                    Packet.writeHeader(output, 5000);
                    Packet.flush(output);
                    Packet.readHeader(input, 5001);
                    String vmName = Packet.readString(input);
                    String vmVersion = Packet.readString(input);
                    String vmVendor = Packet.readString(input);
                    String inputArguments = Packet.readString(input);
                    String classPath = Packet.readString(input);
                    String libraryPath = Packet.readString(input);
                    String bootClassPath = Packet.readString(input);
                    String osName = Packet.readString(input);
                    String osArch = Packet.readString(input);
                    String osVersion = Packet.readString(input);
                    long startTime = Packet.readLong(input);
                    ControllerImpl.this.myJVMInfo = new JVMInfo(vmName, vmVersion, vmVendor, inputArguments, classPath, libraryPath, bootClassPath, osName, osArch, osVersion, startTime);
                }
            });
        }
        if ((this.myCapabilities & 0x400L) != 0L) {
            this.makeRequest(new Communication(){

                public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                    Packet.writeHeader(output, 5500);
                    Packet.flush(output);
                    Packet.readHeader(input, 5501);
                    String clrVersion = Packet.readString(input);
                    String commandLine = Packet.readString(input);
                    String osName = Packet.readString(input);
                    String osArch = Packet.readString(input);
                    String osVersion = Packet.readString(input);
                    long startTime = Packet.readLong(input);
                    ControllerImpl.this.myCLRInfo = new CLRInfo(clrVersion, commandLine, osName, osArch, osVersion, startTime);
                }
            });
        }
        this.myInitialStatus = this.getStatus();
        if ((this.myCapabilities & 0x80L) != 0L) {
            this.myInitialUsedMemoryThreshold = this.getUsedMemoryThreshold();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeRequest(Communication communication) throws Exception {
        try {
            Socket socket = new Socket(this.myHost, this.myPort);
            try {
                DataOutputStream out = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
                try {
                    DataInputStream input = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
                    try {
                        communication.perform(input, out);
                    }
                    finally {
                        input.close();
                    }
                }
                finally {
                    out.close();
                }
            }
            finally {
                socket.close();
            }
        }
        catch (Throwable exc) {
            throw this.transformException(exc);
        }
    }

    private Exception transformException(Throwable exc) {
        String message;
        if (exc instanceof UnknownHostException) {
            return new Exception("Cannot connect to host " + this.myHost);
        }
        if (exc instanceof AgentProtocolException) {
            return new Exception("Communication with the profiler agent failed.\nPossible reason: the agent is incompatible with the current version of the profiler.", exc);
        }
        if (exc instanceof AgentReportedErrorException) {
            return (Exception)exc;
        }
        if (exc instanceof IOException && (message = exc.getMessage()) != null && (message.startsWith("Connection refused") || message.startsWith("Connection reset"))) {
            return new Exception("There's no application running at " + this.myHost + " with profiler agent configured to listen on port " + this.myPort, exc);
        }
        return new Exception("There's no application running at " + this.myHost + " with profiler agent configured to listen on port " + this.myPort + "\nor profiler agent is incompatible with current version of profiler", exc);
    }

    public final String getHost() {
        return this.myHost;
    }

    public final int getPort() {
        return this.myPort;
    }

    public final long getStatus() throws Exception {
        final long[] result = new long[1];
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 2000);
                Packet.flush(output);
                Packet.readHeader(input, 2001);
                result[0] = Packet.readLong(input);
            }
        });
        return result[0];
    }

    public final String getSessionName() {
        return this.mySessionName;
    }

    public final String getSnapshotDir() {
        return this.mySnapshotDir;
    }

    public final JVMInfo getJVMInfo() {
        if ((this.myCapabilities & 0x200L) == 0L) {
            throw new UnsupportedOperationException();
        }
        return this.myJVMInfo;
    }

    public final CLRInfo getCLRInfo() {
        if ((this.myCapabilities & 0x400L) == 0L) {
            throw new UnsupportedOperationException();
        }
        return this.myCLRInfo;
    }

    public final void startCPUMeasuring(final int mode) throws Exception {
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                if (mode == 0) {
                    Packet.writeHeader(output, 8000);
                    Packet.flush(output);
                    Packet.readHeader(input, 8001);
                } else if (mode == 1) {
                    Packet.writeHeader(output, 9000);
                    Packet.flush(output);
                    Packet.readHeader(input, 9001);
                } else if (mode == 2) {
                    Packet.writeHeader(output, 8500);
                    Packet.flush(output);
                    Packet.readHeader(input, 8501);
                } else {
                    throw new AgentProtocolException("unexpected mode " + mode);
                }
            }
        });
    }

    public void stopCPUMeasuring() throws Exception {
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 10000);
                Packet.flush(output);
                Packet.readHeader(input, 10001);
            }
        });
    }

    public void startAllocationsRecording() throws Exception {
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 6000);
                Packet.flush(output);
                Packet.readHeader(input, 6001);
            }
        });
    }

    public void stopAllocationsRecording() throws Exception {
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 7000);
                Packet.flush(output);
                Packet.readHeader(input, 7001);
            }
        });
    }

    public final long[] forceGC() throws Exception {
        final long[] result = new long[2];
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 11000);
                Packet.flush(output);
                Packet.readHeader(input, 11001);
                result[0] = Packet.readLong(input);
                result[1] = Packet.readLong(input);
            }
        });
        return result;
    }

    public final long getInitialStatus() {
        return this.myInitialStatus;
    }

    public int getInitialUsedMemoryThreshold() {
        return this.myInitialUsedMemoryThreshold;
    }

    public long getCapabilities() {
        return this.myCapabilities;
    }

    public TelemetryRecord[] getTelemetryRecords(final long timestamp) throws Exception {
        final TelemetryRecord[][] result = new TelemetryRecord[1][];
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 20000);
                Packet.writeLong(output, timestamp);
                Packet.flush(output);
                Packet.readHeader(input, 20001);
                int recordsToFollow = Packet.readInt(input);
                if (recordsToFollow < 0) {
                    throw new AgentProtocolException("Invalid recordsToFollow: " + recordsToFollow);
                }
                result[0] = new TelemetryRecord[recordsToFollow];
                for (int i = 0; i < recordsToFollow; ++i) {
                    Packet.readHeader(input, 20002);
                    long timestamp2 = Packet.readLong(input);
                    int valueCount = Packet.readInt(input);
                    if (valueCount < 0) {
                        throw new AgentProtocolException("Invalid valueCount: " + valueCount);
                    }
                    long[] values = new long[valueCount];
                    for (int j = 0; j < values.length; ++j) {
                        values[j] = Packet.readLong(input);
                    }
                    result[0][i] = new TelemetryRecord(timestamp2, values);
                }
            }
        });
        return result[0];
    }

    public final CaptureSnapshotRes captureMemorySnapshot(final boolean continueAllocationRecording, final ProgressListener listener) throws Exception {
        final CaptureSnapshotRes[] result = new CaptureSnapshotRes[1];
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                int packetType;
                Packet.writeHeader(output, 13000);
                Packet.writeInt(output, continueAllocationRecording ? 1 : 0);
                Packet.flush(output);
                while ((packetType = Packet.readHeader(input)) == 14001) {
                    int percents = Packet.readInt(input);
                    if (percents < 0 || percents > 99) {
                        throw new AgentProtocolException("Wrong percents: " + percents);
                    }
                    if (listener == null) continue;
                    listener.update(percents);
                }
                if (packetType != 14002) {
                    throw new AgentProtocolException("Unexpected packet type: " + packetType);
                }
                String path = Packet.readStringNotNull(input);
                long transferID = Packet.readLong(input);
                result[0] = new CaptureSnapshotRes(path, transferID);
            }
        });
        return result[0];
    }

    public final CaptureSnapshotRes captureCPUSnapshot(final boolean continueCPUProfiling, final ProgressListener listener) throws Exception {
        final CaptureSnapshotRes[] result = new CaptureSnapshotRes[1];
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                int packetType;
                Packet.writeHeader(output, 12000);
                Packet.writeInt(output, continueCPUProfiling ? 1 : 0);
                Packet.flush(output);
                while ((packetType = Packet.readHeader(input)) == 12001) {
                    int percents = Packet.readInt(input);
                    if (percents < 0 || percents > 99) {
                        throw new AgentProtocolException("Wrong percents: " + percents);
                    }
                    if (listener == null) continue;
                    listener.update(percents);
                }
                if (packetType != 12002) {
                    throw new AgentProtocolException("Unexpected packet type: " + packetType);
                }
                String path = Packet.readStringNotNull(input);
                long transferID = Packet.readLong(input);
                result[0] = new CaptureSnapshotRes(path, transferID);
            }
        });
        return result[0];
    }

    public final void transferSnapshot(final long transferID, final ChunkProcessor processor) throws Exception {
        Asserts.notNull(processor);
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                int read;
                Packet.writeHeader(output, 15000);
                Packet.writeLong(output, transferID);
                Packet.flush(output);
                byte[] buffer = new byte[65536];
                Packet.readHeader(input, 15001);
                long fileLength = Packet.readLong(input);
                if (fileLength <= 0L) {
                    throw new AgentProtocolException("Wrong fileLength: " + fileLength);
                }
                long transferred = 0L;
                while ((read = Packet.readBytes(input, buffer)) != -1) {
                    if (transferred + (long)read > fileLength) {
                        throw new AgentProtocolException("Too long stream");
                    }
                    processor.processNextChunk(fileLength, buffer, read);
                    if ((transferred += (long)read) != fileLength) continue;
                    break;
                }
            }
        });
    }

    public int getUsedMemoryThreshold() throws Exception {
        final int[] result = new int[1];
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 17000);
                Packet.flush(output);
                Packet.readHeader(input, 17001);
                result[0] = Packet.readInt(input);
            }
        });
        return result[0];
    }

    public void setUsedMemoryThreshold(final int value) throws Exception {
        if (value < 0 || value > 99) {
            throw new IllegalArgumentException("" + value);
        }
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 18000);
                Packet.writeInt(output, value);
                Packet.flush(output);
                Packet.readHeader(input, 18001);
            }
        });
    }

    public ThreadInfoRes[] getAllStackTraces() throws Exception {
        final ThreadInfoRes[][] wrapper = new ThreadInfoRes[1][];
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 32000);
                Packet.flush(output);
                Packet.readHeader(input, 32001);
                int infoCount = Packet.readInt(input);
                ThreadInfoRes[] result = new ThreadInfoRes[infoCount];
                wrapper[0] = result;
                for (int i = infoCount - 1; i >= 0; --i) {
                    long threadID = Packet.readLong(input);
                    String threadName = Packet.readString(input);
                    long blockedTimeMs = Packet.readLong(input);
                    long blockedCount = Packet.readLong(input);
                    long waitedTimeMs = Packet.readLong(input);
                    long waitedCount = Packet.readLong(input);
                    long lockOwerID = Packet.readLong(input);
                    boolean inNative = Packet.readInt(input) != 1;
                    boolean suspnded = Packet.readInt(input) != 0;
                    int statusOrdinal = Packet.readInt(input);
                    int stackTraceElementCount = Packet.readInt(input);
                    StackTraceElementRes[] elements = new StackTraceElementRes[stackTraceElementCount];
                    for (int j = 0; j < stackTraceElementCount; ++j) {
                        String declaringClass = Packet.readString(input);
                        String methodName = Packet.readString(input);
                        String fileName = Packet.readString(input);
                        int lineNumber = Packet.readInt(input);
                        elements[j] = new StackTraceElementRes(declaringClass, methodName, fileName, lineNumber);
                    }
                    result[i] = new ThreadInfoRes(threadID, threadName, blockedTimeMs, blockedCount, waitedTimeMs, waitedCount, lockOwerID, inNative, suspnded, statusOrdinal, elements);
                }
            }
        });
        return wrapper[0];
    }

    public String getJavaVersion() {
        return this.myJavaVersion;
    }

    public static interface ChunkProcessor {
        public void processNextChunk(long var1, byte[] var3, int var4) throws IOException;
    }

    private static interface Communication {
        public void perform(DataInputStream var1, DataOutputStream var2) throws IOException;
    }
}

