/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.tools;

import com.atlassian.confluence.tools.ExportCleaner;
import com.atlassian.confluence.tools.ResourceLoader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.joost.emitter.StreamEmitter;
import net.sf.joost.stx.ParseContext;
import net.sf.joost.stx.Processor;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JoostExportCleaner
implements ExportCleaner {
    private static final Logger log = Logger.getLogger(JoostExportCleaner.class);
    private InputStream stx;

    public JoostExportCleaner(InputStream stx) {
        this.stx = stx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println("Usage: java -jar confluence-export-cleaner.jar input.xml output.xml");
            System.exit(-1);
        }
        FileInputStream input = new FileInputStream(args[0]);
        FileOutputStream output = new FileOutputStream(args[1], false);
        ResourceLoader resourceLoader = new ResourceLoader(JoostExportCleaner.class);
        InputStream stxStream = resourceLoader.getStream("com/atlassian/confluence/tools/clean.stx");
        try {
            JoostExportCleaner cleaner = new JoostExportCleaner(stxStream);
            log.info("Starting to clean export file '" + args[0] + "'. This may take a few minutes.");
            cleaner.clean(input, output);
        }
        finally {
            ((InputStream)input).close();
            ((OutputStream)output).close();
            stxStream.close();
        }
        log.info("Cleaning complete. Output written to '" + args[1] + "'");
    }

    public void clean(InputStream input, OutputStream output) throws IOException {
        try {
            Processor processor = new Processor(new InputSource(this.stx), new ParseContext());
            StreamEmitter emitter = StreamEmitter.newEmitter(output, processor.outputProperties);
            processor.setContentHandler(emitter);
            processor.setLexicalHandler(emitter);
            processor.parse(new InputSource(input));
        }
        catch (SAXException ex) {
            throw new RuntimeException(ex);
        }
    }
}

