/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.emitter;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Properties;
import net.sf.joost.Constants;
import net.sf.joost.OptionalLog;
import net.sf.joost.emitter.HtmlEmitter;
import net.sf.joost.emitter.StxEmitterBase;
import net.sf.joost.emitter.TextEmitter;
import net.sf.joost.emitter.XmlEmitter;
import org.apache.commons.logging.Log;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public abstract class StreamEmitter
extends StxEmitterBase
implements Constants {
    private static Log log = OptionalLog.getLog(class$net$sf$joost$emitter$StreamEmitter == null ? (class$net$sf$joost$emitter$StreamEmitter = StreamEmitter.class$("net.sf.joost.emitter.StreamEmitter")) : class$net$sf$joost$emitter$StreamEmitter);
    private static String HTML_METHOD = "{http://joost.sf.net/extension}html";
    protected Writer writer;
    protected String encoding;
    protected CharsetEncoder charsetEncoder;
    static /* synthetic */ Class class$net$sf$joost$emitter$StreamEmitter;

    public StreamEmitter(Writer writer, String string) {
        this.writer = writer;
        this.encoding = string;
        this.charsetEncoder = Charset.forName(string).newEncoder();
    }

    public static StreamEmitter newEmitter(Writer writer, String string, Properties properties) {
        if (properties != null) {
            String string2 = properties.getProperty("method");
            if (string2 == null || string2.equals("xml")) {
                return new XmlEmitter(writer, string, properties);
            }
            if (string2.equals("text")) {
                return new TextEmitter(writer, string);
            }
            if (string2.equals(HTML_METHOD)) {
                return new HtmlEmitter(writer, string);
            }
            String string3 = "Unsupported output method `" + string2 + "', use default `xml' method instead";
            if (log != null) {
                log.warn((Object)string3);
            } else {
                System.err.println("Warning: " + string3);
            }
        }
        return new XmlEmitter(writer, string, properties);
    }

    public static StreamEmitter newEmitter(OutputStream outputStream, Properties properties) throws IOException {
        OutputStreamWriter outputStreamWriter;
        String string = null;
        if (properties != null) {
            string = properties.getProperty("encoding");
        }
        string = string != null ? string.toUpperCase() : "UTF-8";
        try {
            outputStreamWriter = new OutputStreamWriter(outputStream, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string2 = "Unsupported encoding " + string + ", using " + "UTF-8";
            if (log != null) {
                log.warn((Object)string2);
            } else {
                System.err.println("Warning: " + string2);
            }
            outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        }
        return StreamEmitter.newEmitter(new BufferedWriter(outputStreamWriter), string, properties);
    }

    public static StreamEmitter newXMLEmitter(Writer writer) {
        return StreamEmitter.newEmitter(writer, "UTF-8", null);
    }

    public static StreamEmitter newEmitter(String string, Properties properties) throws IOException {
        return StreamEmitter.newEmitter(new FileOutputStream(string), properties);
    }

    public void setOmitXmlDeclaration(boolean bl) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int encodeCharacters(char[] cArray, int n, StringBuffer stringBuffer) throws SAXException {
        if (cArray[n] >= '\ud800' && cArray[n] <= '\udbff') {
            if (++n >= cArray.length || cArray[n] < '\udc00' || cArray[n] > '\udfff') throw new SAXException("Surrogate pair encoding error - missing low surrogate after code " + cArray[n - 1]);
            stringBuffer.append("&#").append((cArray[n - 1] - 55296) * 1024 + (cArray[n] - 56320) + 65536).append(';');
            return n;
        } else if (this.charsetEncoder.canEncode(cArray[n])) {
            stringBuffer.append(cArray[n]);
            return n;
        } else {
            stringBuffer.append("&#").append((int)cArray[n]).append(';');
        }
        return n;
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public void endPrefixMapping(String string) {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void skippedEntity(String string) {
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDTD(String string, String string2, String string3) {
    }

    public void endDTD() {
    }

    public void startEntity(String string) {
    }

    public void endEntity(String string) {
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

