/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.emitter;

import java.io.IOException;
import java.io.Writer;
import java.util.Properties;
import net.sf.joost.OptionalLog;
import net.sf.joost.emitter.StreamEmitter;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XmlEmitter
extends StreamEmitter {
    private static Log log = OptionalLog.getLog(class$net$sf$joost$emitter$XmlEmitter == null ? (class$net$sf$joost$emitter$XmlEmitter = XmlEmitter.class$("net.sf.joost.emitter.XmlEmitter")) : class$net$sf$joost$emitter$XmlEmitter);
    private boolean propOmitXmlDeclaration = false;
    private boolean propStandalone = false;
    private String propVersion = "1.0";
    private StringBuffer nsDeclarations = new StringBuffer();
    private String lastQName;
    private Attributes lastAttrs;
    private boolean insideCDATA = false;
    static /* synthetic */ Class class$net$sf$joost$emitter$XmlEmitter;

    public XmlEmitter(Writer writer, String string, Properties properties) {
        super(writer, string);
        if (properties != null) {
            String string2 = properties.getProperty("omit-xml-declaration");
            if (string2 != null) {
                this.propOmitXmlDeclaration = string2.equals("yes");
            }
            if (!string.equals("UTF-8") && !string.equals("UTF-16")) {
                this.propOmitXmlDeclaration = false;
            }
            if ((string2 = properties.getProperty("standalone")) != null) {
                this.propStandalone = string2.equals("yes");
            }
            if ((string2 = properties.getProperty("version")) != null) {
                this.propVersion = string2;
            }
        }
    }

    public void setOmitXmlDeclaration(boolean bl) {
        this.propOmitXmlDeclaration = bl;
    }

    private boolean processLastElement(boolean bl) throws SAXException {
        if (this.lastQName != null) {
            StringBuffer stringBuffer = new StringBuffer("<");
            stringBuffer.append(this.lastQName);
            stringBuffer.append(this.nsDeclarations);
            this.nsDeclarations.setLength(0);
            int n = this.lastAttrs.getLength();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(' ').append(this.lastAttrs.getQName(i)).append("=\"");
                char[] cArray = this.lastAttrs.getValue(i).toCharArray();
                block12: for (int j = 0; j < cArray.length; ++j) {
                    switch (cArray[j]) {
                        case '&': {
                            stringBuffer.append("&amp;");
                            continue block12;
                        }
                        case '<': {
                            stringBuffer.append("&lt;");
                            continue block12;
                        }
                        case '>': {
                            stringBuffer.append("&gt;");
                            continue block12;
                        }
                        case '\"': {
                            stringBuffer.append("&quot;");
                            continue block12;
                        }
                        case '\t': {
                            stringBuffer.append("&#x9;");
                            continue block12;
                        }
                        case '\n': {
                            stringBuffer.append("&#xA;");
                            continue block12;
                        }
                        case '\r': {
                            stringBuffer.append("&#xD;");
                            continue block12;
                        }
                        default: {
                            j = this.encodeCharacters(cArray, j, stringBuffer);
                        }
                    }
                }
                stringBuffer.append('\"');
            }
            stringBuffer.append(bl ? " />" : ">");
            try {
                this.writer.write(stringBuffer.toString());
            }
            catch (IOException iOException) {
                if (log != null) {
                    log.error((Object)iOException);
                }
                throw new SAXException(iOException);
            }
            this.lastQName = null;
            return true;
        }
        return false;
    }

    public void startDocument() throws SAXException {
        if (this.propOmitXmlDeclaration) {
            return;
        }
        try {
            this.writer.write("<?xml version=\"");
            this.writer.write(this.propVersion);
            this.writer.write("\" encoding=\"");
            this.writer.write(this.encoding);
            if (this.propStandalone) {
                this.writer.write("\" standalone=\"yes");
            }
            this.writer.write("\"?>\n");
        }
        catch (IOException iOException) {
            if (log != null) {
                log.error((Object)iOException);
            }
            throw new SAXException(iOException);
        }
    }

    public void endDocument() throws SAXException {
        this.processLastElement(false);
        try {
            this.writer.write("\n");
            this.writer.flush();
        }
        catch (IOException iOException) {
            if (log != null) {
                log.error((Object)iOException);
            }
            throw new SAXException(iOException);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.processLastElement(false);
        this.lastQName = string3;
        this.lastAttrs = attributes;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (!this.processLastElement(true)) {
            try {
                this.writer.write("</");
                this.writer.write(string3);
                this.writer.write(">");
            }
            catch (IOException iOException) {
                if (log != null) {
                    log.error((Object)iOException);
                }
                throw new SAXException(iOException);
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.processLastElement(false);
        try {
            if (this.insideCDATA) {
                for (int i = 0; i < n2; ++i) {
                    if (this.charsetEncoder.canEncode(cArray[n + i])) continue;
                    throw new SAXException("Cannot output character with code " + cArray[n + i] + " in the encoding `" + this.encoding + "' within a CDATA section");
                }
                this.writer.write(cArray, n, n2);
            } else {
                StringBuffer stringBuffer = new StringBuffer(n2);
                block8: for (int i = 0; i < n2; ++i) {
                    switch (cArray[n + i]) {
                        case '&': {
                            stringBuffer.append("&amp;");
                            continue block8;
                        }
                        case '<': {
                            stringBuffer.append("&lt;");
                            continue block8;
                        }
                        case '>': {
                            stringBuffer.append("&gt;");
                            continue block8;
                        }
                        default: {
                            i = this.encodeCharacters(cArray, n + i, stringBuffer) - n;
                        }
                    }
                }
                this.writer.write(stringBuffer.toString());
            }
        }
        catch (IOException iOException) {
            if (log != null) {
                log.error((Object)iOException);
            }
            throw new SAXException(iOException);
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.processLastElement(false);
        if ("".equals(string)) {
            this.nsDeclarations.append(" xmlns=\"");
        } else {
            this.nsDeclarations.append(" xmlns:").append(string).append("=\"");
        }
        this.nsDeclarations.append(string2).append('\"');
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.processLastElement(false);
        try {
            this.writer.write("<?");
            this.writer.write(string);
            if (!string2.equals("")) {
                this.writer.write(" ");
                this.writer.write(string2);
            }
            this.writer.write("?>");
        }
        catch (IOException iOException) {
            if (log != null) {
                log.error((Object)iOException);
            }
            throw new SAXException(iOException);
        }
    }

    public void startCDATA() throws SAXException {
        this.processLastElement(false);
        try {
            this.writer.write("<![CDATA[");
        }
        catch (IOException iOException) {
            if (log != null) {
                log.error((Object)iOException);
            }
            throw new SAXException(iOException);
        }
        this.insideCDATA = true;
    }

    public void endCDATA() throws SAXException {
        this.insideCDATA = false;
        try {
            this.writer.write("]]>");
        }
        catch (IOException iOException) {
            if (log != null) {
                log.error((Object)iOException);
            }
            throw new SAXException(iOException);
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        this.processLastElement(false);
        try {
            this.writer.write("<!--");
            this.writer.write(cArray, n, n2);
            this.writer.write("-->");
        }
        catch (IOException iOException) {
            if (log != null) {
                log.error((Object)iOException);
            }
            throw new SAXException(iOException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

