/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.instruction;

import java.util.HashSet;
import java.util.Hashtable;
import net.sf.joost.emitter.StringEmitter;
import net.sf.joost.grammar.Tree;
import net.sf.joost.instruction.FactoryBase;
import net.sf.joost.instruction.NodeBase;
import net.sf.joost.stx.Context;
import net.sf.joost.stx.ParseContext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class AttributeFactory
extends FactoryBase {
    private HashSet attrNames = new HashSet();

    public AttributeFactory() {
        this.attrNames.add("name");
        this.attrNames.add("select");
        this.attrNames.add("namespace");
    }

    public String getName() {
        return "attribute";
    }

    public NodeBase createNode(NodeBase nodeBase, String string, Attributes attributes, ParseContext parseContext) throws SAXParseException {
        Tree tree = AttributeFactory.parseExpr(attributes.getValue("select"), parseContext);
        Tree tree2 = AttributeFactory.parseAVT(AttributeFactory.getAttribute(string, attributes, "name", parseContext), parseContext);
        Tree tree3 = AttributeFactory.parseAVT(attributes.getValue("namespace"), parseContext);
        AttributeFactory.checkAttributes(string, attributes, this.attrNames, parseContext);
        return new Instance(string, nodeBase, parseContext, tree2, tree3, tree);
    }

    public final class Instance
    extends NodeBase {
        private Tree name;
        private Tree namespace;
        private Tree select;
        private Hashtable nsSet;
        private StringEmitter strEmitter;

        protected Instance(String string, NodeBase nodeBase, ParseContext parseContext, Tree tree, Tree tree2, Tree tree3) {
            super(string, nodeBase, parseContext, tree3 == null);
            this.nsSet = (Hashtable)parseContext.nsSet.clone();
            this.name = tree;
            this.namespace = tree2;
            this.select = tree3;
            this.strEmitter = new StringEmitter(new StringBuffer(), "(`" + this.qName + "' started in line " + this.lineNo + ")");
        }

        public short process(Context context) throws SAXException {
            String string;
            String string2;
            String string3;
            int n;
            if (context.emitter.isEmitterActive(this.strEmitter)) {
                context.errorHandler.error("Can't create nested attribute", this.publicId, this.systemId, this.lineNo, this.colNo);
                return 0;
            }
            if (this.select == null) {
                super.process(context);
                this.strEmitter.getBuffer().setLength(0);
                context.pushEmitter(this.strEmitter);
            }
            if ((n = (string3 = this.name.evaluate(context, this).getString()).indexOf(58)) != -1) {
                String string4 = string3.substring(0, n);
                string2 = string3.substring(n + 1);
                if (this.namespace != null) {
                    string = this.namespace.evaluate(context, this).getString();
                    if (string.equals("")) {
                        context.errorHandler.error("Can't put attribute `" + string3 + "' into the null namespace", this.publicId, this.systemId, this.lineNo, this.colNo);
                        return 0;
                    }
                } else {
                    string = (String)this.nsSet.get(string4);
                    if (string == null) {
                        context.errorHandler.error("Attempt to create attribute `" + string3 + "' with undeclared prefix `" + string4 + "'", this.publicId, this.systemId, this.lineNo, this.colNo);
                        return 0;
                    }
                }
            } else {
                string2 = string3;
                string = "";
                if (this.namespace != null && !(string = this.namespace.evaluate(context, this).getString()).equals("")) {
                    context.errorHandler.error("Can't put attribute `" + string3 + "' into the non-null namespace `" + string + "'", this.publicId, this.systemId, this.lineNo, this.colNo);
                    return 0;
                }
            }
            if (this.select != null) {
                context.emitter.addAttribute(string, string3, string2, this.select.evaluate(context, this).getStringValue(), this);
            } else {
                this.localFieldStack.push(string);
                this.localFieldStack.push(string2);
                this.localFieldStack.push(string3);
            }
            return 0;
        }

        public short processEnd(Context context) throws SAXException {
            String string = (String)this.localFieldStack.pop();
            String string2 = (String)this.localFieldStack.pop();
            String string3 = (String)this.localFieldStack.pop();
            context.popEmitter();
            context.emitter.addAttribute(string3, string, string2, this.strEmitter.getBuffer().toString(), this);
            return super.processEnd(context);
        }
    }
}

