/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.instruction;

import java.util.HashSet;
import net.sf.joost.emitter.StringEmitter;
import net.sf.joost.grammar.Tree;
import net.sf.joost.instruction.FactoryBase;
import net.sf.joost.instruction.NodeBase;
import net.sf.joost.stx.Context;
import net.sf.joost.stx.ParseContext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CommentFactory
extends FactoryBase {
    private HashSet attrNames = new HashSet();

    public CommentFactory() {
        this.attrNames.add("select");
    }

    public String getName() {
        return "comment";
    }

    public NodeBase createNode(NodeBase nodeBase, String string, Attributes attributes, ParseContext parseContext) throws SAXParseException {
        Tree tree = CommentFactory.parseExpr(attributes.getValue("select"), parseContext);
        CommentFactory.checkAttributes(string, attributes, this.attrNames, parseContext);
        return new Instance(string, nodeBase, parseContext, tree);
    }

    public class Instance
    extends NodeBase {
        private Tree select;
        private StringEmitter strEmitter;
        private StringBuffer buffer;

        public Instance(String string, NodeBase nodeBase, ParseContext parseContext, Tree tree) {
            super(string, nodeBase, parseContext, tree == null);
            this.select = tree;
            this.buffer = new StringBuffer();
            this.strEmitter = new StringEmitter(this.buffer, "(`" + string + "' started in line " + this.lineNo + ")");
        }

        public short process(Context context) throws SAXException {
            if (this.select == null) {
                super.process(context);
                if (context.emitter.isEmitterActive(this.strEmitter)) {
                    context.errorHandler.error("Can't create nested comment here", this.publicId, this.systemId, this.lineNo, this.colNo);
                    return 0;
                }
                this.buffer.setLength(0);
                context.pushEmitter(this.strEmitter);
            } else {
                String string = this.select.evaluate(context, this).getStringValue();
                if (string.indexOf(45) != -1) {
                    this.emitComment(new StringBuffer(string), context);
                } else {
                    context.emitter.comment(string.toCharArray(), 0, string.length(), this);
                }
            }
            return 0;
        }

        public short processEnd(Context context) throws SAXException {
            context.popEmitter();
            this.emitComment(this.buffer, context);
            return super.processEnd(context);
        }

        private void emitComment(StringBuffer stringBuffer, Context context) throws SAXException {
            int n = stringBuffer.length();
            if (n != 0) {
                if (stringBuffer.charAt(0) == '-') {
                    stringBuffer.insert(0, ' ');
                }
                String string = stringBuffer.toString();
                while (true) {
                    --n;
                    if ((n = string.lastIndexOf("--", n)) == -1) break;
                    stringBuffer.insert(n + 1, ' ');
                }
                if (stringBuffer.charAt(stringBuffer.length() - 1) == '-') {
                    stringBuffer.append(' ');
                }
            }
            context.emitter.comment(stringBuffer.toString().toCharArray(), 0, stringBuffer.length(), this);
        }
    }
}

