/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.instruction;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import javax.xml.transform.TransformerException;
import net.sf.joost.OptionalLog;
import net.sf.joost.emitter.StreamEmitter;
import net.sf.joost.emitter.StxEmitter;
import net.sf.joost.grammar.Tree;
import net.sf.joost.instruction.FactoryBase;
import net.sf.joost.instruction.NodeBase;
import net.sf.joost.stx.Context;
import net.sf.joost.stx.ParseContext;
import net.sf.joost.trax.SourceLocatorImpl;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class MessageFactory
extends FactoryBase {
    private HashSet attrNames = new HashSet();
    private static final String[] LEVEL_VALUES = new String[]{"trace", "debug", "info", "warn", "error", "fatal"};
    private static final int TRACE_LEVEL = 0;
    private static final int DEBUG_LEVEL = 1;
    private static final int INFO_LEVEL = 2;
    private static final int WARN_LEVEL = 3;
    private static final int ERROR_LEVEL = 4;
    private static final int FATAL_LEVEL = 5;

    public MessageFactory() {
        this.attrNames.add("select");
        this.attrNames.add("terminate");
        this.attrNames.add("level");
        this.attrNames.add("logger");
    }

    public String getName() {
        return "message";
    }

    public NodeBase createNode(NodeBase nodeBase, String string, Attributes attributes, ParseContext parseContext) throws SAXParseException {
        String string2;
        Tree tree = MessageFactory.parseExpr(attributes.getValue("select"), parseContext);
        Tree tree2 = MessageFactory.parseAVT(attributes.getValue("terminate"), parseContext);
        int n = MessageFactory.getEnumAttValue("level", attributes, LEVEL_VALUES, parseContext);
        if (n != -1 ^ (string2 = attributes.getValue("logger")) != null) {
            throw new SAXParseException(n != -1 ? "Missing `logger' attribute when `level' is present" : "Missing `level' attribute when `logger' is present", parseContext.locator);
        }
        MessageFactory.checkAttributes(string, attributes, this.attrNames, parseContext);
        return new Instance(string, nodeBase, parseContext, tree, tree2, n, string2);
    }

    public final class Instance
    extends NodeBase {
        private Tree select;
        private Tree terminate;
        private Log log;
        private int level;
        private StringBuffer buffer;
        private StxEmitter emitter;

        protected Instance(String string, NodeBase nodeBase, ParseContext parseContext, Tree tree, Tree tree2, int n, String string2) {
            super(string, nodeBase, parseContext, tree == null);
            this.select = tree;
            this.terminate = tree2;
            this.level = n;
            if (string2 != null) {
                this.log = OptionalLog.getLog(string2);
            }
        }

        public short process(Context context) throws SAXException {
            Object object;
            if (this.emitter == null) {
                try {
                    if (this.log != null) {
                        object = new StringWriter();
                        this.buffer = ((StringWriter)object).getBuffer();
                        StreamEmitter streamEmitter = StreamEmitter.newEmitter((Writer)object, "UTF-8", context.currentProcessor.outputProperties);
                        streamEmitter.setOmitXmlDeclaration(true);
                        this.emitter = streamEmitter;
                    } else if (context.messageEmitter == null) {
                        object = StreamEmitter.newEmitter(System.err, context.currentProcessor.outputProperties);
                        ((StreamEmitter)object).setOmitXmlDeclaration(true);
                        context.messageEmitter = this.emitter = object;
                    } else {
                        this.emitter = context.messageEmitter;
                    }
                }
                catch (IOException iOException) {
                    context.errorHandler.fatalError(iOException.toString(), this.publicId, this.systemId, this.lineNo, this.colNo);
                    return 0;
                }
            }
            if (this.select == null) {
                super.process(context);
                this.emitter.startDocument();
                context.pushEmitter(this.emitter);
            } else {
                this.emitter.startDocument();
                object = this.select.evaluate(context, this).getStringValue();
                this.emitter.characters(((String)object).toCharArray(), 0, ((String)object).length());
                this.emitter.endDocument();
                this.processMessage(context);
            }
            return 0;
        }

        public short processEnd(Context context) throws SAXException {
            context.popEmitter().endDocument();
            this.processMessage(context);
            return super.processEnd(context);
        }

        private void processMessage(Context context) throws SAXException {
            CharSequence charSequence;
            if (this.log != null) {
                charSequence = new StringBuffer(this.systemId).append(':').append(this.lineNo).append(':').append(this.colNo).append(": ").append(this.buffer);
                switch (this.level) {
                    case 0: {
                        this.log.trace((Object)((StringBuffer)charSequence).toString());
                        break;
                    }
                    case 1: {
                        this.log.debug((Object)((StringBuffer)charSequence).toString());
                        break;
                    }
                    case 2: {
                        this.log.info((Object)((StringBuffer)charSequence).toString());
                        break;
                    }
                    case 3: {
                        this.log.warn((Object)((StringBuffer)charSequence).toString());
                        break;
                    }
                    case 4: {
                        this.log.error((Object)((StringBuffer)charSequence).toString());
                        break;
                    }
                    case 5: {
                        this.log.fatal((Object)((StringBuffer)charSequence).toString());
                    }
                }
                this.buffer.setLength(0);
            }
            if (this.terminate == null) {
                return;
            }
            charSequence = this.terminate.evaluate(context, this).getString();
            if (((String)charSequence).equals("yes")) {
                throw new SAXException(new TransformerException("Transformation terminated", new SourceLocatorImpl(this.publicId, this.systemId, this.lineNo, this.colNo)));
            }
            if (!((String)charSequence).equals("no")) {
                context.errorHandler.fatalError("Attribute 'terminate' of `" + this.qName + "' must be `yes' or `no', found `" + (String)charSequence + "'", this.publicId, this.systemId, this.lineNo, this.colNo);
            }
        }
    }
}

