/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.instruction;

import java.util.HashSet;
import net.sf.joost.emitter.StringEmitter;
import net.sf.joost.grammar.Tree;
import net.sf.joost.instruction.FactoryBase;
import net.sf.joost.instruction.NodeBase;
import net.sf.joost.stx.Context;
import net.sf.joost.stx.ParseContext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class PIFactory
extends FactoryBase {
    private HashSet attrNames = new HashSet();

    public PIFactory() {
        this.attrNames.add("name");
        this.attrNames.add("select");
    }

    public String getName() {
        return "processing-instruction";
    }

    public NodeBase createNode(NodeBase nodeBase, String string, Attributes attributes, ParseContext parseContext) throws SAXParseException {
        Tree tree = PIFactory.parseAVT(PIFactory.getAttribute(string, attributes, "name", parseContext), parseContext);
        Tree tree2 = PIFactory.parseExpr(attributes.getValue("select"), parseContext);
        PIFactory.checkAttributes(string, attributes, this.attrNames, parseContext);
        return new Instance(string, nodeBase, parseContext, tree, tree2);
    }

    public final class Instance
    extends NodeBase {
        private Tree name;
        private Tree select;
        private StringEmitter strEmitter;
        private StringBuffer buffer;
        private String piName;

        protected Instance(String string, NodeBase nodeBase, ParseContext parseContext, Tree tree, Tree tree2) {
            super(string, nodeBase, parseContext, tree2 == null);
            this.name = tree;
            this.select = tree2;
            this.buffer = new StringBuffer();
            this.strEmitter = new StringEmitter(this.buffer, "(`" + string + "' started in line " + this.lineNo + ")");
        }

        public short process(Context context) throws SAXException {
            this.piName = this.name.evaluate(context, this).getString();
            if (this.select == null) {
                super.process(context);
                if (context.emitter.isEmitterActive(this.strEmitter)) {
                    context.errorHandler.error("Can't create nested processing instruction here", this.publicId, this.systemId, this.lineNo, this.colNo);
                    return 0;
                }
                this.buffer.setLength(0);
                context.pushEmitter(this.strEmitter);
            } else {
                String string = this.select.evaluate(context, this).getStringValue();
                int n = string.lastIndexOf("?>");
                if (n != -1) {
                    StringBuffer stringBuffer = new StringBuffer(string);
                    do {
                        stringBuffer.insert(n + 1, ' ');
                        --n;
                    } while ((n = string.lastIndexOf("?>", n)) != -1);
                    string = stringBuffer.toString();
                }
                context.emitter.processingInstruction(this.piName, string, this);
            }
            return 0;
        }

        public short processEnd(Context context) throws SAXException {
            context.popEmitter();
            int n = this.buffer.length();
            if (n != 0) {
                String string = this.buffer.toString();
                while (true) {
                    --n;
                    if ((n = string.lastIndexOf("?>", n)) == -1) break;
                    this.buffer.insert(n + 1, ' ');
                }
            }
            context.emitter.processingInstruction(this.piName, this.buffer.toString(), this);
            return super.processEnd(context);
        }
    }
}

