/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.instruction;

import java.io.IOException;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Properties;
import net.sf.joost.emitter.StreamEmitter;
import net.sf.joost.grammar.Tree;
import net.sf.joost.instruction.FactoryBase;
import net.sf.joost.instruction.NodeBase;
import net.sf.joost.stx.Context;
import net.sf.joost.stx.ParseContext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class ResultDocumentFactory
extends FactoryBase {
    private HashSet attrNames = new HashSet();

    public ResultDocumentFactory() {
        this.attrNames.add("href");
        this.attrNames.add("output-encoding");
        this.attrNames.add("output-method");
        this.attrNames.add("append");
    }

    public String getName() {
        return "result-document";
    }

    public NodeBase createNode(NodeBase nodeBase, String string, Attributes attributes, ParseContext parseContext) throws SAXParseException {
        Tree tree = ResultDocumentFactory.parseAVT(ResultDocumentFactory.getAttribute(string, attributes, "href", parseContext), parseContext);
        String string2 = attributes.getValue("output-encoding");
        String string3 = attributes.getValue("output-method");
        if (string3 != null) {
            if (string3.indexOf(58) != -1) {
                string3 = ResultDocumentFactory.getExpandedName(string3, parseContext);
            } else if (!string3.equals("text") && !string3.equals("xml")) {
                throw new SAXParseException("Value of attribute `output-method' must be `xml', `text', or a qualified name. Found `" + string3 + "'", parseContext.locator);
            }
        }
        boolean bl = ResultDocumentFactory.getEnumAttValue("append", attributes, YESNO_VALUES, parseContext) == 0;
        ResultDocumentFactory.checkAttributes(string, attributes, this.attrNames, parseContext);
        return new Instance(string, nodeBase, parseContext, tree, string2, string3, bl);
    }

    public final class Instance
    extends NodeBase {
        private Tree href;
        private String encoding;
        private String method;
        private boolean append;

        protected Instance(String string, NodeBase nodeBase, ParseContext parseContext, Tree tree, String string2, String string3, boolean bl) {
            super(string, nodeBase, parseContext, true);
            this.href = tree;
            this.encoding = string2;
            this.method = string3;
            this.append = bl;
        }

        public short process(Context context) throws SAXException {
            super.process(context);
            if (this.encoding == null) {
                this.encoding = context.currentProcessor.getOutputEncoding();
            }
            String string = this.href.evaluate(context, this).getString();
            StreamEmitter streamEmitter = null;
            try {
                Writer writer = context.emitter.getResultWriter(string, this.encoding, this.publicId, this.systemId, this.lineNo, this.colNo, this.append);
                Properties properties = (Properties)context.currentProcessor.outputProperties.clone();
                properties.setProperty("encoding", this.encoding);
                if (this.method != null) {
                    properties.setProperty("method", this.method);
                }
                streamEmitter = StreamEmitter.newEmitter(writer, this.encoding, properties);
                if (this.append) {
                    streamEmitter.setOmitXmlDeclaration(true);
                }
                this.localFieldStack.push(writer);
            }
            catch (IOException iOException) {
                context.errorHandler.error(iOException.toString(), this.publicId, this.systemId, this.lineNo, this.colNo);
                return 0;
            }
            catch (URISyntaxException uRISyntaxException) {
                context.errorHandler.error(uRISyntaxException.toString(), this.publicId, this.systemId, this.lineNo, this.colNo);
                return 0;
            }
            context.pushEmitter(streamEmitter);
            context.emitter.startDocument();
            return 0;
        }

        public short processEnd(Context context) throws SAXException {
            context.emitter.endDocument(this.nodeEnd);
            context.popEmitter();
            try {
                ((Writer)this.localFieldStack.pop()).close();
            }
            catch (IOException iOException) {
                context.errorHandler.error(iOException.toString(), this.publicId, this.systemId, this.nodeEnd.lineNo, this.nodeEnd.colNo);
                return 0;
            }
            return super.processEnd(context);
        }
    }
}

