/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.instruction;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashSet;
import net.sf.joost.instruction.FactoryBase;
import net.sf.joost.instruction.GroupBase;
import net.sf.joost.instruction.NodeBase;
import net.sf.joost.instruction.TextNode;
import net.sf.joost.stx.Context;
import net.sf.joost.stx.ParseContext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class ScriptFactory
extends FactoryBase {
    private HashSet attrNames = new HashSet();

    public ScriptFactory() {
        this.attrNames.add("prefix");
        this.attrNames.add("language");
        this.attrNames.add("src");
    }

    public String getName() {
        return "script";
    }

    public NodeBase createNode(NodeBase nodeBase, String string, Attributes attributes, ParseContext parseContext) throws SAXParseException {
        if (nodeBase != null && !(nodeBase instanceof GroupBase)) {
            throw new SAXParseException("`" + string + "' not allowed as child of `" + nodeBase.qName + "'", parseContext.locator);
        }
        String string2 = ScriptFactory.getAttribute(string, attributes, "prefix", parseContext);
        if (!parseContext.nsSet.containsKey(string2)) {
            throw new SAXParseException("Prefix `" + string2 + "' must belong to a declared namespace in element `" + string + "'", parseContext.locator);
        }
        String string3 = (String)parseContext.nsSet.get(string2);
        if (parseContext.getFunctionFactory().isScriptPrefix(string2)) {
            throw new SAXParseException("Prefix `" + string2 + "' of `" + string + "' has been already defined by another script element", parseContext.locator);
        }
        String string4 = attributes.getValue("src");
        String string5 = ScriptFactory.getAttribute(string, attributes, "language", parseContext);
        ScriptFactory.checkAttributes(string, attributes, this.attrNames, parseContext);
        return new Instance(string, nodeBase, parseContext, string2, string3, string4, string5);
    }

    public final class Instance
    extends NodeBase {
        private String prefix;
        private String scriptUri;
        private String lang;
        private String src;
        private String script;

        protected Instance(String string, NodeBase nodeBase, ParseContext parseContext, String string2, String string3, String string4, String string5) {
            super(string, nodeBase, parseContext, false);
            this.prefix = string2;
            this.scriptUri = string3;
            this.src = string4;
            this.lang = string5;
        }

        public String toString() {
            return "script (" + this.lineNo + ") ";
        }

        public void insert(NodeBase nodeBase) throws SAXParseException {
            if (!(nodeBase instanceof TextNode)) {
                throw new SAXParseException("`" + this.qName + "' may only contain text (script code)" + "(encountered `" + nodeBase.qName + "')", nodeBase.publicId, nodeBase.systemId, nodeBase.lineNo, nodeBase.colNo);
            }
            if (this.src != null) {
                throw new SAXParseException("`" + this.qName + "' may not contain text (script code) if the `src' " + "attribute is used", nodeBase.publicId, nodeBase.systemId, nodeBase.lineNo, nodeBase.colNo);
            }
            this.script = ((TextNode)nodeBase).getContents();
        }

        public boolean compile(int n, ParseContext parseContext) throws SAXException {
            String string = null;
            if (this.src == null) {
                string = this.script;
            } else {
                try {
                    String string2;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new URL(new URL(parseContext.locator.getSystemId()), this.src).openStream()));
                    StringBuffer stringBuffer = new StringBuffer(4096);
                    while ((string2 = bufferedReader.readLine()) != null) {
                        stringBuffer.append('\n');
                        stringBuffer.append(string2);
                    }
                    string = stringBuffer.toString();
                }
                catch (IOException iOException) {
                    throw new SAXParseException("Exception while reading from " + this.src, this.publicId, this.systemId, this.lineNo, this.colNo, iOException);
                }
            }
            parseContext.getFunctionFactory().addScript(this, string);
            return false;
        }

        public boolean processable() {
            return false;
        }

        public short process(Context context) throws SAXException {
            throw new SAXParseException("process called for " + this.qName, this.publicId, this.systemId, this.lineNo, this.colNo);
        }

        public String getLang() {
            return this.lang;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getUri() {
            return this.scriptUri;
        }
    }
}

