/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.instruction;

import java.util.HashSet;
import net.sf.joost.grammar.Tree;
import net.sf.joost.instruction.FactoryBase;
import net.sf.joost.instruction.GroupBase;
import net.sf.joost.instruction.NodeBase;
import net.sf.joost.instruction.TemplateBase;
import net.sf.joost.instruction.TransformFactory;
import net.sf.joost.stx.Context;
import net.sf.joost.stx.ParseContext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class TemplateFactory
extends FactoryBase {
    private HashSet attrNames = new HashSet();

    public TemplateFactory() {
        this.attrNames.add("match");
        this.attrNames.add("priority");
        this.attrNames.add("visibility");
        this.attrNames.add("public");
        this.attrNames.add("new-scope");
    }

    public String getName() {
        return "template";
    }

    public NodeBase createNode(NodeBase nodeBase, String string, Attributes attributes, ParseContext parseContext) throws SAXParseException {
        double d;
        if (nodeBase == null || !(nodeBase instanceof GroupBase)) {
            throw new SAXParseException("`" + string + "' must be a top level " + "element or a child of stx:group", parseContext.locator);
        }
        String string2 = TemplateFactory.getAttribute(string, attributes, "match", parseContext);
        Tree tree = TemplateFactory.parsePattern(string2, parseContext);
        String string3 = attributes.getValue("priority");
        if (string3 != null) {
            try {
                d = Double.parseDouble(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXParseException("The priority value `" + string3 + "' is not a number", parseContext.locator);
            }
        } else {
            d = tree.getPriority();
        }
        int n = TemplateFactory.getEnumAttValue("visibility", attributes, TemplateBase.VISIBILITY_VALUES, parseContext);
        if (n == -1) {
            n = 0;
        }
        int n2 = TemplateFactory.getEnumAttValue("public", attributes, YESNO_VALUES, parseContext);
        boolean bl = nodeBase instanceof TransformFactory.Instance ? n2 != 1 : n2 == 0;
        boolean bl2 = TemplateFactory.getEnumAttValue("new-scope", attributes, YESNO_VALUES, parseContext) == 0;
        TemplateFactory.checkAttributes(string, attributes, this.attrNames, parseContext);
        return new Instance(string, nodeBase, parseContext, tree, d, n, bl, bl2);
    }

    public final class Instance
    extends TemplateBase
    implements Cloneable,
    Comparable {
        private Tree match;
        private double priority;

        protected Instance(String string, NodeBase nodeBase, ParseContext parseContext, Tree tree, double d, int n, boolean bl, boolean bl2) {
            super(string, nodeBase, parseContext, n, bl, bl2);
            this.match = tree;
            this.priority = d;
        }

        public boolean matches(Context context, boolean bl) throws SAXException {
            context.currentInstruction = this;
            context.currentGroup = this.parentGroup;
            return this.match.matches(context, context.ancestorStack.size(), bl);
        }

        public Instance split() throws SAXException {
            if (this.match.type != 4) {
                return null;
            }
            Instance instance = null;
            try {
                instance = (Instance)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new SAXException("Can't split " + this, cloneNotSupportedException);
            }
            instance.match = this.match.right;
            if (Double.isNaN(instance.priority)) {
                instance.priority = instance.match.getPriority();
            }
            this.match = this.match.left;
            if (Double.isNaN(this.priority)) {
                this.priority = this.match.getPriority();
            }
            return instance;
        }

        public double getPriority() {
            return this.priority;
        }

        public Tree getMatchPattern() {
            return this.match;
        }

        public int compareTo(Object object) {
            double d = ((Instance)object).priority;
            return d < this.priority ? -1 : (d > this.priority ? 1 : 0);
        }

        public String toString() {
            return "template:" + this.lineNo + " " + this.match + " " + this.priority;
        }
    }
}

