/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.instruction;

import java.io.StringWriter;
import java.util.HashSet;
import net.sf.joost.emitter.StreamEmitter;
import net.sf.joost.emitter.StringEmitter;
import net.sf.joost.emitter.StxEmitter;
import net.sf.joost.instruction.FactoryBase;
import net.sf.joost.instruction.NodeBase;
import net.sf.joost.stx.Context;
import net.sf.joost.stx.ParseContext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TextFactory
extends FactoryBase {
    private HashSet attrNames = new HashSet();
    private static final String[] MARKUP_VALUES = new String[]{"error", "ignore", "serialize"};
    private static final int NO_MARKUP = 0;
    private static final int IGNORE_MARKUP = 1;
    private static final int SERIALIZE_MARKUP = 2;

    public TextFactory() {
        this.attrNames.add("markup");
    }

    public String getName() {
        return "text";
    }

    public NodeBase createNode(NodeBase nodeBase, String string, Attributes attributes, ParseContext parseContext) throws SAXParseException {
        int n = TextFactory.getEnumAttValue("markup", attributes, MARKUP_VALUES, parseContext);
        if (n == -1) {
            n = 0;
        }
        TextFactory.checkAttributes(string, attributes, this.attrNames, parseContext);
        return new Instance(string, nodeBase, parseContext, n);
    }

    public class Instance
    extends NodeBase {
        private StxEmitter stxEmitter;
        private StringBuffer buffer;
        private int recursionLevel = 0;

        public Instance(String string, NodeBase nodeBase, ParseContext parseContext, int n) {
            super(string, nodeBase, parseContext, true);
            if (n == 2) {
                StringWriter stringWriter = new StringWriter();
                this.buffer = stringWriter.getBuffer();
                this.stxEmitter = StreamEmitter.newXMLEmitter(stringWriter);
            } else {
                this.buffer = new StringBuffer();
                this.stxEmitter = new StringEmitter(this.buffer, n == 0 ? "(`" + string + "' with the `markup' attribute set to `" + MARKUP_VALUES[0] + "' started in line " + this.lineNo + ")" : null);
            }
        }

        public short process(Context context) throws SAXException {
            super.process(context);
            if (this.recursionLevel++ == 0) {
                this.buffer.setLength(0);
                context.pushEmitter(this.stxEmitter);
            }
            return 0;
        }

        public short processEnd(Context context) throws SAXException {
            if (--this.recursionLevel == 0) {
                context.popEmitter();
                context.emitter.characters(this.buffer.toString().toCharArray(), 0, this.buffer.length(), this);
            }
            return super.processEnd(context);
        }
    }
}

