/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.instruction;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import net.sf.joost.instruction.FactoryBase;
import net.sf.joost.instruction.GroupBase;
import net.sf.joost.instruction.NSAliasFactory;
import net.sf.joost.instruction.NodeBase;
import net.sf.joost.instruction.ScriptFactory;
import net.sf.joost.instruction.TemplateBase;
import net.sf.joost.instruction.VariableBase;
import net.sf.joost.stx.ParseContext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;

public class TransformFactory
extends FactoryBase {
    private static final String[] PASS_THROUGH_VALUES = new String[]{"none", "text", "all"};
    private HashSet attrNames = new HashSet();
    private static final String EXCLUDE_RESULT_PREFIXES = "exclude-result-prefixes";

    public TransformFactory() {
        this.attrNames.add("version");
        this.attrNames.add("output-encoding");
        this.attrNames.add("output-method");
        this.attrNames.add("stxpath-default-namespace");
        this.attrNames.add("pass-through");
        this.attrNames.add("recognize-cdata");
        this.attrNames.add("strip-space");
        this.attrNames.add(EXCLUDE_RESULT_PREFIXES);
    }

    public String getName() {
        return "transform";
    }

    public NodeBase createNode(NodeBase nodeBase, String string, Attributes attributes, ParseContext parseContext) throws SAXParseException {
        if (nodeBase != null && nodeBase.systemId.equals(parseContext.locator.getSystemId())) {
            throw new SAXParseException("`" + string + "' is allowed only as root element", parseContext.locator);
        }
        String string2 = TransformFactory.getAttribute(string, attributes, "version", parseContext);
        if (!string2.equals("1.0")) {
            throw new SAXParseException("Unknown STX version `" + string2 + "'. The only supported version is 1.0.", parseContext.locator);
        }
        String string3 = attributes.getValue("output-encoding");
        String string4 = attributes.getValue("output-method");
        if (string4 != null) {
            if (string4.indexOf(58) != -1) {
                string4 = TransformFactory.getExpandedName(string4, parseContext);
            } else if (!string4.equals("text") && !string4.equals("xml")) {
                throw new SAXParseException("Value of attribute `output-method' must be `xml', `text', or a qualified name. Found `" + string4 + "'", parseContext.locator);
            }
        }
        String string5 = attributes.getValue("stxpath-default-namespace");
        byte by = 0;
        switch (TransformFactory.getEnumAttValue("pass-through", attributes, PASS_THROUGH_VALUES, parseContext)) {
            case -1: 
            case 0: {
                by = 0;
                break;
            }
            case 1: {
                by = 2;
                break;
            }
            case 2: {
                by = -1;
                break;
            }
            default: {
                throw new SAXParseException("Unexpected return value from getEnumAttValue", parseContext.locator);
            }
        }
        boolean bl = TransformFactory.getEnumAttValue("strip-space", attributes, YESNO_VALUES, parseContext) == 0;
        boolean bl2 = TransformFactory.getEnumAttValue("recognize-cdata", attributes, YESNO_VALUES, parseContext) != 1;
        String string6 = attributes.getValue(EXCLUDE_RESULT_PREFIXES);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("http://stx.sourceforge.net/2002/ns");
        if (string6 != null) {
            int n = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string6);
            while (stringTokenizer.hasMoreTokens()) {
                Object v;
                ++n;
                String string7 = stringTokenizer.nextToken();
                if ("#all".equals(string7)) {
                    if (n != 1 || stringTokenizer.hasMoreTokens()) {
                        throw new SAXParseException("The value `#all' must be used standalone in the `exclude-result-prefixes' attribute", parseContext.locator);
                    }
                    hashSet.addAll(parseContext.nsSet.values());
                    break;
                }
                if ("#default".equals(string7)) {
                    string7 = "";
                }
                if ((v = parseContext.nsSet.get(string7)) != null) {
                    hashSet.add((String)v);
                    continue;
                }
                if (string7 == "") {
                    throw new SAXParseException("No default namespace declared to be excluded by using the value `#default' in the `exclude-result-prefixes' attribute", parseContext.locator);
                }
                throw new SAXParseException("No namespace declared for prefix `" + string7 + "' in the `" + EXCLUDE_RESULT_PREFIXES + "' attribute", parseContext.locator);
            }
        }
        TransformFactory.checkAttributes(string, attributes, this.attrNames, parseContext);
        return new Instance(nodeBase, string, parseContext, string3, string4, string5, by, bl, bl2, hashSet);
    }

    public final class Instance
    extends GroupBase {
        public Hashtable namespaceAliases;
        public String outputEncoding;
        public String outputMethod;
        public String stxpathDefaultNamespace;
        public HashSet excludedNamespaces;
        public Vector compilableNodes;

        public Instance(NodeBase nodeBase, String string, ParseContext parseContext, String string2, String string3, String string4, byte by, boolean bl, boolean bl2, HashSet hashSet) {
            super(string, nodeBase, parseContext, by, bl, bl2);
            if (nodeBase == null) {
                this.namedGroups = new Hashtable();
                this.globalProcedures = new Hashtable();
                this.namespaceAliases = new Hashtable();
            } else {
                while (!(nodeBase instanceof Instance)) {
                    nodeBase = nodeBase.parent;
                }
                this.namespaceAliases = ((Instance)nodeBase).namespaceAliases;
            }
            this.outputEncoding = string2 != null ? string2 : "UTF-8";
            this.outputMethod = string3 != null ? string3 : "xml";
            this.stxpathDefaultNamespace = string4 != null ? string4 : "";
            this.excludedNamespaces = hashSet;
        }

        public Vector getChildren() {
            return this.children;
        }

        public void insert(NodeBase nodeBase) throws SAXParseException {
            if (this.compilableNodes != null) {
                throw new SAXParseException("`" + this.qName + "' must be empty", nodeBase.publicId, nodeBase.systemId, nodeBase.lineNo, nodeBase.colNo);
            }
            if (nodeBase instanceof TemplateBase || nodeBase instanceof GroupBase || nodeBase instanceof VariableBase) {
                super.insert(nodeBase);
            } else if (!(nodeBase instanceof NSAliasFactory.Instance) && !(nodeBase instanceof ScriptFactory.Instance)) {
                throw new SAXParseException("`" + nodeBase.qName + "' not allowed as top level element", nodeBase.publicId, nodeBase.systemId, nodeBase.lineNo, nodeBase.colNo);
            }
        }
    }
}

