/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.plugins.traxfilter;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import net.sf.joost.Constants;
import net.sf.joost.OptionalLog;
import net.sf.joost.TransformerHandlerResolver;
import net.sf.joost.plugins.attributes.Attribute;
import net.sf.joost.plugins.attributes.BooleanAttribute;
import net.sf.joost.plugins.attributes.StringAttribute;
import net.sf.joost.plugins.traxfilter.XalanReusableTH;
import net.sf.joost.trax.TransformerFactoryImpl;
import org.apache.commons.logging.Log;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class THResolver
implements TransformerHandlerResolver,
Constants {
    public static final String STX_METHOD = "http://stx.sourceforge.net/2002/ns";
    public static final String XSLT_METHOD = "http://www.w3.org/1999/XSL/Transform";
    public static final String TRAX_METHOD = "http://java.sun.com/xml/jaxp";
    public static final String FILTER_ATTR_NS = "http://stx.sourceforge.net/2002/ns/trax-filter";
    public static final String TRAX_ATTR_NS = "http://stx.sourceforge.net/2002/ns/trax-filter/attribute";
    static final String tmp_FILTER_ATTR_NS = "{http://stx.sourceforge.net/2002/ns/trax-filter}";
    static final String tmp_TRAX_ATTR_NS = "{http://stx.sourceforge.net/2002/ns/trax-filter/attribute}";
    static Hashtable attrs;
    public static final BooleanAttribute REUSE_TH_URL;
    public static final BooleanAttribute REUSE_TH_BUFFER;
    public static final StringAttribute FACTORY;
    public static final BooleanAttribute HREF_IS_SYSTEM_ID;
    public static final BooleanAttribute USE_INTERNAL_XALAN_TH;
    private static final Class XALAN_IMPL_CLASS;
    private static final Class XALAN_XSLT_IMPL_CLASS;
    static final String XMLREADER_KEY = "_XMLREADER";
    static Hashtable cachedTH;
    static TransformerFactoryImpl stxTraxFactory;
    static final String[] METHODS;
    static Log log;
    static /* synthetic */ Class class$net$sf$joost$plugins$traxfilter$THResolver;

    public String[] resolves() {
        return METHODS;
    }

    public TransformerHandler resolve(String string, String string2, String string3, URIResolver uRIResolver, Hashtable hashtable) throws SAXException {
        if (!this.available(string)) {
            throw new SAXException("Not supported filter-method:" + string);
        }
        if (string2 == null) {
            throw new SAXException("method-src must be url() or buffer()");
        }
        this.setFilterAttributes(hashtable);
        TransformerHandler transformerHandler = null;
        transformerHandler = this.getReusableHrefTH(string, string2);
        if (transformerHandler == null) {
            Source source = null;
            try {
                if (uRIResolver != null) {
                    source = uRIResolver.resolve(string2, string3);
                }
                if (source == null) {
                    if (HREF_IS_SYSTEM_ID.booleanValue()) {
                        source = new StreamSource(string2);
                    } else {
                        String string4 = new URL(new URL(string3), string2).toExternalForm();
                        source = new StreamSource(string4);
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw new SAXException(malformedURLException);
            }
            catch (TransformerException transformerException) {
                throw new SAXException(transformerException);
            }
            transformerHandler = this.newTHOutOfTraX(string, source, hashtable);
            this.cacheHrefTH(string, string2, transformerHandler);
        }
        this.prepareTh(transformerHandler, hashtable);
        return transformerHandler;
    }

    public TransformerHandler resolve(String string, XMLReader xMLReader, Hashtable hashtable) throws SAXException {
        if (!this.available(string)) {
            throw new SAXException("Not supported filter-method:" + string);
        }
        if (xMLReader == null) {
            throw new SAXException("method-src must be url() or buffer()");
        }
        this.setFilterAttributes(hashtable);
        TransformerHandler transformerHandler = null;
        transformerHandler = this.getReusableXmlReaderTH(string);
        if (transformerHandler == null) {
            SAXSource sAXSource = new SAXSource(xMLReader, new InputSource());
            transformerHandler = this.newTHOutOfTraX(string, sAXSource, hashtable);
            this.cacheBufferTH(string, transformerHandler);
        }
        this.prepareTh(transformerHandler, hashtable);
        return transformerHandler;
    }

    public boolean available(String string) {
        return STX_METHOD.equals(string) || XSLT_METHOD.equals(string) || TRAX_METHOD.equals(string);
    }

    protected TransformerHandler getReusableHrefTH(String string, String string2) {
        if (REUSE_TH_URL.booleanValue()) {
            return (TransformerHandler)cachedTH.get(string + string2);
        }
        return null;
    }

    protected void cacheHrefTH(String string, String string2, TransformerHandler transformerHandler) {
        if (REUSE_TH_URL.booleanValue()) {
            cachedTH.put(string + string2, transformerHandler);
        }
    }

    protected TransformerHandler getReusableXmlReaderTH(String string) {
        if (REUSE_TH_BUFFER.booleanValue()) {
            return (TransformerHandler)cachedTH.get(string + XMLREADER_KEY);
        }
        return null;
    }

    protected void cacheBufferTH(String string, TransformerHandler transformerHandler) {
        if (REUSE_TH_BUFFER.booleanValue()) {
            cachedTH.put(string + XMLREADER_KEY, transformerHandler);
        }
    }

    protected TransformerHandler newTHOutOfTraX(String string, Source source, Hashtable hashtable) throws SAXException {
        SAXTransformerFactory sAXTransformerFactory;
        if (FACTORY.getValueStr().length() > 0) {
            try {
                sAXTransformerFactory = (SAXTransformerFactory)Class.forName(FACTORY.getValueStr()).newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new SAXException(instantiationException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SAXException(classNotFoundException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SAXException(illegalAccessException);
            }
        }
        if (STX_METHOD.equals(string)) {
            if (stxTraxFactory == null) {
                try {
                    stxTraxFactory = new TransformerFactoryImpl();
                }
                catch (IOException iOException) {
                    throw new SAXException(iOException);
                }
            }
            sAXTransformerFactory = stxTraxFactory;
        } else {
            Properties properties;
            String string2 = System.getProperty("javax.xml.transform.TransformerFactory");
            boolean bl = false;
            String string3 = System.getProperty("http://joost.sf.net/attributes/xslt-factory");
            if (string3 != null || "net.sf.joost.trax.TransformerFactoryImpl".equals(string2)) {
                if (string3 != null) {
                    System.setProperty("javax.xml.transform.TransformerFactory", string3);
                } else {
                    properties = System.getProperties();
                    properties.remove("javax.xml.transform.TransformerFactory");
                    System.setProperties(properties);
                }
                bl = true;
            }
            sAXTransformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
            if (bl) {
                if (string2 != null) {
                    System.setProperty("javax.xml.transform.TransformerFactory", string2);
                } else {
                    properties = System.getProperties();
                    properties.remove("javax.xml.transform.TransformerFactory");
                    System.setProperties(properties);
                }
            }
        }
        this.setTraxFactoryAttributes(sAXTransformerFactory, hashtable);
        try {
            if ((XALAN_IMPL_CLASS != null && XALAN_IMPL_CLASS.isAssignableFrom(sAXTransformerFactory.getClass()) || XALAN_XSLT_IMPL_CLASS != null && XALAN_XSLT_IMPL_CLASS.isAssignableFrom(sAXTransformerFactory.getClass())) && USE_INTERNAL_XALAN_TH.booleanValue()) {
                Transformer transformer = sAXTransformerFactory.newTransformer(source);
                return new XalanReusableTH(transformer);
            }
            return sAXTransformerFactory.newTransformerHandler(source);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new SAXException(transformerConfigurationException);
        }
    }

    protected void setTraxFactoryAttributes(SAXTransformerFactory sAXTransformerFactory, Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith(tmp_TRAX_ATTR_NS)) continue;
            String string2 = string.substring(tmp_TRAX_ATTR_NS.length()).toLowerCase();
            sAXTransformerFactory.setAttribute(string2, hashtable.get(string));
        }
    }

    protected void prepareTh(TransformerHandler transformerHandler, Hashtable hashtable) {
        Transformer transformer = transformerHandler.getTransformer();
        transformer.clearParameters();
        if (!hashtable.isEmpty()) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string.startsWith(tmp_TRAX_ATTR_NS) || string.startsWith(tmp_FILTER_ATTR_NS)) continue;
                transformer.setParameter(string, hashtable.get(string));
            }
        }
    }

    protected void setFilterAttributes(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith(tmp_FILTER_ATTR_NS)) continue;
            String string2 = string.substring(tmp_FILTER_ATTR_NS.length()).toLowerCase();
            Attribute attribute = (Attribute)attrs.get(string2);
            if (attribute == null) {
                throw new IllegalArgumentException("setFilterAttributes() : " + string2 + " not supported");
            }
            attribute.setValue((String)hashtable.get(string));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class<?> clazz;
        attrs = new Hashtable();
        REUSE_TH_URL = new BooleanAttribute("REUSE-TH-URL", System.getProperty("http://stx.sourceforge.net/2002/ns/trax-filter:REUSE-TH-URL", "false"), attrs);
        REUSE_TH_BUFFER = new BooleanAttribute("REUSE-TH-BUFFER", System.getProperty("http://stx.sourceforge.net/2002/ns/trax-filter:REUSE-TH-BUFFER", "false"), attrs);
        FACTORY = new StringAttribute("FACTORY", System.getProperty("http://stx.sourceforge.net/2002/ns/trax-filter:FACTORY", ""), attrs);
        HREF_IS_SYSTEM_ID = new BooleanAttribute("THREAT-URL-AS-SYSTEM_ID", System.getProperty("http://stx.sourceforge.net/2002/ns/trax-filter:THREAT-URL-AS-SYSTEM_ID", "false"), attrs);
        USE_INTERNAL_XALAN_TH = new BooleanAttribute("USE-INTERNAL-XALAN-TH", "true", attrs);
        try {
            clazz = Class.forName("org.apache.xalan.processor.TransformerFactoryImpl");
        }
        catch (Throwable throwable) {
            clazz = null;
        }
        XALAN_IMPL_CLASS = clazz;
        try {
            clazz = Class.forName("org.apache.xalan.xsltc.trax.TransformerFactoryImpl");
        }
        catch (Throwable throwable) {
            clazz = null;
        }
        XALAN_XSLT_IMPL_CLASS = clazz;
        cachedTH = new Hashtable(5);
        stxTraxFactory = null;
        METHODS = new String[]{STX_METHOD, XSLT_METHOD, TRAX_METHOD};
        log = OptionalLog.getLog(class$net$sf$joost$plugins$traxfilter$THResolver == null ? (class$net$sf$joost$plugins$traxfilter$THResolver = THResolver.class$("net.sf.joost.plugins.traxfilter.THResolver")) : class$net$sf$joost$plugins$traxfilter$THResolver);
    }
}

