/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.stx;

import java.util.Hashtable;
import java.util.Stack;
import net.sf.joost.Constants;
import net.sf.joost.emitter.BufferEmitter;
import net.sf.joost.instruction.GroupBase;
import net.sf.joost.stx.Context;
import net.sf.joost.stx.Emitter;
import net.sf.joost.stx.SAXEvent;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class BufferReader
implements XMLReader,
Constants {
    private LexicalHandler lexH;
    private ContentHandler contH;
    private SAXEvent[] events;

    public BufferReader(Context context, String string, String string2, String string3, String string4, int n, int n2) throws SAXException {
        Constants constants;
        Object v = context.localVars.get(string2);
        if (v == null) {
            constants = context.currentGroup;
            while (v == null && constants != null) {
                v = ((Hashtable)((Stack)context.groupVars.get(constants)).peek()).get(string2);
                constants = ((GroupBase)constants).parentGroup;
            }
        }
        if (v == null) {
            context.errorHandler.error("Can't process an undeclared buffer `" + string + "'", string3, string4, n, n2);
            this.events = new SAXEvent[0];
            return;
        }
        constants = (Emitter)v;
        ((Emitter)constants).endDocument(context.currentInstruction);
        this.events = ((BufferEmitter)((Emitter)constants).contH).getEvents();
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://xml.org/sax/features/namespaces")) {
            if (!bl) {
                throw new SAXNotSupportedException("Cannot switch off namespace support (attempt setting " + string + " to " + bl + ")");
            }
        } else if (string.equals("http://xml.org/sax/features/namespace-prefixes")) {
            if (bl) {
                throw new SAXNotSupportedException("Cannot report namespace declarations as attributes (attempt setting " + string + " to " + bl + ")");
            }
        } else {
            throw new SAXNotRecognizedException(string);
        }
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException {
        if (string.equals("http://xml.org/sax/features/namespaces")) {
            return true;
        }
        if (string.equals("http://xml.org/sax/features/namespace-prefixes")) {
            return false;
        }
        throw new SAXNotRecognizedException(string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (!string.equals("http://xml.org/sax/properties/lexical-handler")) {
            throw new SAXNotRecognizedException(string);
        }
        this.lexH = (LexicalHandler)object;
    }

    public Object getProperty(String string) throws SAXNotRecognizedException {
        if (string.equals("http://xml.org/sax/properties/lexical-handler")) {
            return this.lexH;
        }
        throw new SAXNotRecognizedException(string);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contH = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contH;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void parse(InputSource inputSource) throws SAXException {
        if (this.contH == null) {
            throw new SAXException("Missing ContentHandler for buffer processing");
        }
        if (this.lexH == null && this.contH instanceof LexicalHandler) {
            this.lexH = (LexicalHandler)((Object)this.contH);
        }
        this.contH.startDocument();
        this.parse(this.contH, this.lexH);
        this.contH.endDocument();
    }

    public void parse(String string) throws SAXException {
        this.parse((InputSource)null);
    }

    public void parse(ContentHandler contentHandler, LexicalHandler lexicalHandler) throws SAXException {
        block10: for (int i = 0; i < this.events.length; ++i) {
            SAXEvent sAXEvent = this.events[i];
            switch (sAXEvent.type) {
                case 1: {
                    contentHandler.startElement(sAXEvent.uri, sAXEvent.lName, sAXEvent.qName, sAXEvent.attrs);
                    continue block10;
                }
                case 7: {
                    contentHandler.endElement(sAXEvent.uri, sAXEvent.lName, sAXEvent.qName);
                    continue block10;
                }
                case 2: {
                    contentHandler.characters(sAXEvent.value.toCharArray(), 0, sAXEvent.value.length());
                    continue block10;
                }
                case 3: {
                    if (lexicalHandler != null) {
                        lexicalHandler.startCDATA();
                        contentHandler.characters(sAXEvent.value.toCharArray(), 0, sAXEvent.value.length());
                        lexicalHandler.endCDATA();
                        continue block10;
                    }
                    contentHandler.characters(sAXEvent.value.toCharArray(), 0, sAXEvent.value.length());
                    continue block10;
                }
                case 4: {
                    contentHandler.processingInstruction(sAXEvent.qName, sAXEvent.value);
                    continue block10;
                }
                case 5: {
                    if (lexicalHandler == null) continue block10;
                    lexicalHandler.comment(sAXEvent.value.toCharArray(), 0, sAXEvent.value.length());
                    continue block10;
                }
                case 8: {
                    contentHandler.startPrefixMapping(sAXEvent.qName, sAXEvent.value);
                    continue block10;
                }
                case 9: {
                    contentHandler.endPrefixMapping(sAXEvent.qName);
                }
            }
        }
    }
}

