/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.stx;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import net.sf.joost.Constants;
import net.sf.joost.instruction.AssignFactory;
import net.sf.joost.instruction.AttributeFactory;
import net.sf.joost.instruction.BufferFactory;
import net.sf.joost.instruction.CallProcedureFactory;
import net.sf.joost.instruction.CdataFactory;
import net.sf.joost.instruction.ChooseFactory;
import net.sf.joost.instruction.CommentFactory;
import net.sf.joost.instruction.CopyFactory;
import net.sf.joost.instruction.ElementEndFactory;
import net.sf.joost.instruction.ElementFactory;
import net.sf.joost.instruction.ElementStartFactory;
import net.sf.joost.instruction.ElseFactory;
import net.sf.joost.instruction.FactoryBase;
import net.sf.joost.instruction.ForEachFactory;
import net.sf.joost.instruction.GroupBase;
import net.sf.joost.instruction.GroupFactory;
import net.sf.joost.instruction.IfFactory;
import net.sf.joost.instruction.IncludeFactory;
import net.sf.joost.instruction.LitElementFactory;
import net.sf.joost.instruction.MessageFactory;
import net.sf.joost.instruction.NSAliasFactory;
import net.sf.joost.instruction.NodeBase;
import net.sf.joost.instruction.OtherwiseFactory;
import net.sf.joost.instruction.PAttributesFactory;
import net.sf.joost.instruction.PBufferFactory;
import net.sf.joost.instruction.PChildrenFactory;
import net.sf.joost.instruction.PDocumentFactory;
import net.sf.joost.instruction.PIFactory;
import net.sf.joost.instruction.PSelfFactory;
import net.sf.joost.instruction.PSiblingsFactory;
import net.sf.joost.instruction.ParamFactory;
import net.sf.joost.instruction.ProcedureFactory;
import net.sf.joost.instruction.ResultBufferFactory;
import net.sf.joost.instruction.ResultDocumentFactory;
import net.sf.joost.instruction.ScriptFactory;
import net.sf.joost.instruction.TemplateFactory;
import net.sf.joost.instruction.TextFactory;
import net.sf.joost.instruction.TextNode;
import net.sf.joost.instruction.TransformFactory;
import net.sf.joost.instruction.ValueOfFactory;
import net.sf.joost.instruction.VariableFactory;
import net.sf.joost.instruction.WhenFactory;
import net.sf.joost.instruction.WhileFactory;
import net.sf.joost.instruction.WithParamFactory;
import net.sf.joost.stx.ParseContext;
import net.sf.joost.stx.ParserListener;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Parser
implements Constants,
ContentHandler {
    private ParseContext pContext;
    private Stack openedElements;
    private NodeBase currentNode;
    private Hashtable stxFactories;
    private Hashtable joostFactories;
    private LitElementFactory litFac;
    private Hashtable inScopeNamespaces;
    private Hashtable newNamespaces;
    public Vector compilableNodes = new Vector();
    public GroupBase includingGroup;
    private ParserListener parserListener;
    private StringBuffer collectedCharacters = new StringBuffer();

    public Parser(ParseContext parseContext) {
        this.pContext = parseContext;
        this.parserListener = parseContext.parserListener;
        FactoryBase[] factoryBaseArray = new FactoryBase[]{new TransformFactory(), new GroupFactory(), new IncludeFactory(), new NSAliasFactory(), new TemplateFactory(), new ProcedureFactory(), new CallProcedureFactory(), new ParamFactory(), new VariableFactory(), new AssignFactory(), new WithParamFactory(), new ValueOfFactory(), new PChildrenFactory(), new PSelfFactory(), new PSiblingsFactory(), new PAttributesFactory(), new PDocumentFactory(), new ResultDocumentFactory(), new BufferFactory(), new ResultBufferFactory(), new PBufferFactory(), new CopyFactory(), new TextFactory(), new CdataFactory(), new AttributeFactory(), new ElementFactory(), new ElementStartFactory(), new ElementEndFactory(), new CommentFactory(), new PIFactory(), new ForEachFactory(), new WhileFactory(), new IfFactory(), new ElseFactory(), new ChooseFactory(), new WhenFactory(), new OtherwiseFactory(), new MessageFactory()};
        this.stxFactories = this.createFactoryMap(factoryBaseArray);
        FactoryBase[] factoryBaseArray2 = new FactoryBase[]{new ScriptFactory()};
        this.joostFactories = this.createFactoryMap(factoryBaseArray2);
        this.litFac = new LitElementFactory();
        this.openedElements = new Stack();
        this.inScopeNamespaces = new Hashtable();
        this.newNamespaces = new Hashtable();
    }

    private Hashtable createFactoryMap(FactoryBase[] factoryBaseArray) {
        Hashtable<String, FactoryBase> hashtable = new Hashtable<String, FactoryBase>(factoryBaseArray.length);
        for (int i = 0; i < factoryBaseArray.length; ++i) {
            hashtable.put(factoryBaseArray[i].getName(), factoryBaseArray[i]);
        }
        return hashtable;
    }

    public Map getFactories() {
        return this.stxFactories;
    }

    public TransformFactory.Instance getTransformNode() {
        return this.pContext.transformNode;
    }

    private void processCharacters() throws SAXParseException {
        String string = this.collectedCharacters.toString();
        if (this.currentNode.preserveSpace || string.trim().length() != 0) {
            if (this.currentNode instanceof GroupBase) {
                if (string.trim().length() != 0) {
                    throw new SAXParseException("Text must not occur on group level", this.pContext.locator);
                }
            } else {
                TextNode textNode = new TextNode(string, this.currentNode, this.pContext);
                this.currentNode.insert(textNode);
                if (this.parserListener != null) {
                    this.parserListener.nodeCreated(textNode);
                }
            }
        }
        this.collectedCharacters.setLength(0);
    }

    public void setDocumentLocator(Locator locator) {
        this.pContext.locator = locator;
    }

    public void startDocument() throws SAXException {
        this.startPrefixMapping("xml", "http://www.w3.org/XML/1998/namespace");
    }

    public void endDocument() throws SAXException {
        this.endPrefixMapping("xml");
        if (this.includingGroup != null) {
            return;
        }
        try {
            int n;
            int n2 = 0;
            while ((n = this.compilableNodes.size()) != 0) {
                ++n2;
                NodeBase[] nodeBaseArray = new NodeBase[n];
                this.compilableNodes.toArray(nodeBaseArray);
                this.compilableNodes.clear();
                for (int i = 0; i < n; ++i) {
                    if (!nodeBaseArray[i].compile(n2, this.pContext)) continue;
                    this.compilableNodes.addElement(nodeBaseArray[i]);
                }
            }
            this.compilableNodes = null;
            if (this.parserListener != null) {
                this.parserListener.parseFinished();
            }
        }
        catch (SAXParseException sAXParseException) {
            this.pContext.getErrorHandler().error(sAXParseException);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            int n;
            NodeBase nodeBase;
            FactoryBase factoryBase;
            if (this.collectedCharacters.length() != 0) {
                this.processCharacters();
            }
            this.pContext.nsSet = this.getInScopeNamespaces();
            if ("http://stx.sourceforge.net/2002/ns".equals(string)) {
                factoryBase = (FactoryBase)this.stxFactories.get(string2);
                if (factoryBase == null) {
                    throw new SAXParseException("Unknown statement `" + string3 + "'", this.pContext.locator);
                }
                nodeBase = factoryBase.createNode(this.currentNode != null ? this.currentNode : this.includingGroup, string3, attributes, this.pContext);
                if (this.pContext.transformNode == null) {
                    try {
                        this.pContext.transformNode = (TransformFactory.Instance)nodeBase;
                    }
                    catch (ClassCastException classCastException) {
                        throw new SAXParseException("Found `" + string3 + "' as root element, " + "file is not an STX transformation sheet", this.pContext.locator);
                    }
                }
                if (factoryBase instanceof CopyFactory || factoryBase instanceof ElementFactory || factoryBase instanceof ElementStartFactory) {
                    this.newNamespaces = this.getInScopeNamespaces();
                }
            } else if ("http://joost.sf.net/extension".equals(string)) {
                factoryBase = (FactoryBase)this.joostFactories.get(string2);
                if (factoryBase == null) {
                    throw new SAXParseException("Unknown statement `" + string3 + "'", this.pContext.locator);
                }
                nodeBase = factoryBase.createNode(this.currentNode != null ? this.currentNode : this.includingGroup, string3, attributes, this.pContext);
            } else {
                nodeBase = this.litFac.createNode(this.currentNode, string, string2, string3, attributes, this.pContext, this.newNamespaces);
                this.newNamespaces = new Hashtable();
            }
            if ((n = attributes.getIndex("http://www.w3.org/XML/1998/namespace", "space")) != -1) {
                String string4 = attributes.getValue(n);
                if ("preserve".equals(string4)) {
                    nodeBase.preserveSpace = true;
                } else if (!"default".equals(string4)) {
                    throw new SAXParseException("Value of attribute `" + attributes.getQName(n) + "' must be either `preserve' or `default' (found `" + string4 + "')", this.pContext.locator);
                }
            } else if (nodeBase instanceof TextFactory.Instance || nodeBase instanceof CdataFactory.Instance) {
                nodeBase.preserveSpace = true;
            } else if (this.currentNode != null) {
                nodeBase.preserveSpace = this.currentNode.preserveSpace;
            }
            if (this.currentNode != null) {
                this.currentNode.insert(nodeBase);
            }
            this.openedElements.push(this.currentNode);
            this.currentNode = nodeBase;
            if (this.parserListener != null) {
                this.parserListener.nodeCreated(nodeBase);
            }
        }
        catch (SAXParseException sAXParseException) {
            this.pContext.getErrorHandler().error(sAXParseException);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            if (this.collectedCharacters.length() != 0) {
                this.processCharacters();
            }
            this.currentNode.setEndLocation(this.pContext);
            if (this.currentNode instanceof LitElementFactory.Instance) {
                this.newNamespaces = ((LitElementFactory.Instance)this.currentNode).getNamespaces();
            }
            if ((this.currentNode != this.pContext.transformNode || this.includingGroup == null) && this.currentNode.compile(0, this.pContext)) {
                this.compilableNodes.addElement(this.currentNode);
            }
            if (this.currentNode instanceof TransformFactory.Instance && this.currentNode != this.pContext.transformNode) {
                this.compilableNodes.addAll(((TransformFactory.Instance)this.currentNode).compilableNodes);
            }
            this.currentNode = (NodeBase)this.openedElements.pop();
        }
        catch (SAXParseException sAXParseException) {
            this.pContext.getErrorHandler().error(sAXParseException);
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        this.collectedCharacters.append(cArray, n, n2);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
        this.characters(cArray, n, n2);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        try {
            if (this.collectedCharacters.length() != 0) {
                this.processCharacters();
            }
        }
        catch (SAXParseException sAXParseException) {
            this.pContext.getErrorHandler().error(sAXParseException);
        }
    }

    public void startPrefixMapping(String string, String string2) {
        Stack<String> stack = (Stack<String>)this.inScopeNamespaces.get(string);
        if (stack == null) {
            stack = new Stack<String>();
            this.inScopeNamespaces.put(string, stack);
        }
        stack.push(string2);
        this.newNamespaces.put(string, string2);
    }

    public void endPrefixMapping(String string) {
        Stack stack = (Stack)this.inScopeNamespaces.get(string);
        stack.pop();
        this.newNamespaces.remove(string);
    }

    public void skippedEntity(String string) {
    }

    public Hashtable getInScopeNamespaces() {
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = this.inScopeNamespaces.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Stack stack = (Stack)this.inScopeNamespaces.get(k);
            if (stack.isEmpty()) continue;
            hashtable.put(k, stack.peek());
        }
        return hashtable;
    }
}

