/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.stx.function;

import java.util.Hashtable;
import net.sf.joost.Constants;
import net.sf.joost.grammar.EvalException;
import net.sf.joost.grammar.Tree;
import net.sf.joost.instruction.ScriptFactory;
import net.sf.joost.stx.Context;
import net.sf.joost.stx.ParseContext;
import net.sf.joost.stx.SAXEvent;
import net.sf.joost.stx.Value;
import net.sf.joost.stx.function.Avg;
import net.sf.joost.stx.function.BooleanConv;
import net.sf.joost.stx.function.Ceiling;
import net.sf.joost.stx.function.Concat;
import net.sf.joost.stx.function.Contains;
import net.sf.joost.stx.function.Count;
import net.sf.joost.stx.function.Empty;
import net.sf.joost.stx.function.EndsWith;
import net.sf.joost.stx.function.EscapeUri;
import net.sf.joost.stx.function.Exists;
import net.sf.joost.stx.function.ExtSequence;
import net.sf.joost.stx.function.ExtensionFunction;
import net.sf.joost.stx.function.False;
import net.sf.joost.stx.function.FilterAvailable;
import net.sf.joost.stx.function.Floor;
import net.sf.joost.stx.function.GetInScopePrefixes;
import net.sf.joost.stx.function.GetNamespaceUriForPrefix;
import net.sf.joost.stx.function.HasChildNodes;
import net.sf.joost.stx.function.IndexOf;
import net.sf.joost.stx.function.InsertBefore;
import net.sf.joost.stx.function.ItemAt;
import net.sf.joost.stx.function.LocalName;
import net.sf.joost.stx.function.Max;
import net.sf.joost.stx.function.Min;
import net.sf.joost.stx.function.Name;
import net.sf.joost.stx.function.NamespaceURI;
import net.sf.joost.stx.function.NodeKind;
import net.sf.joost.stx.function.NormalizeSpace;
import net.sf.joost.stx.function.Not;
import net.sf.joost.stx.function.NumberConv;
import net.sf.joost.stx.function.Position;
import net.sf.joost.stx.function.Remove;
import net.sf.joost.stx.function.Round;
import net.sf.joost.stx.function.ScriptFunction;
import net.sf.joost.stx.function.StartsWith;
import net.sf.joost.stx.function.StringConv;
import net.sf.joost.stx.function.StringJoin;
import net.sf.joost.stx.function.StringLength;
import net.sf.joost.stx.function.StringPad;
import net.sf.joost.stx.function.Subsequence;
import net.sf.joost.stx.function.Substring;
import net.sf.joost.stx.function.SubstringAfter;
import net.sf.joost.stx.function.SubstringBefore;
import net.sf.joost.stx.function.Sum;
import net.sf.joost.stx.function.Translate;
import net.sf.joost.stx.function.True;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFManager;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class FunctionFactory
implements Constants {
    public static final String FNSP = "{http://stx.sourceforge.net/2003/functions}";
    public static final String JENSP = "{http://joost.sf.net/extension}";
    private static Hashtable functionHash;
    private ParseContext pContext;
    private Hashtable scriptUriMap = new Hashtable();
    private BSFManager bsfManager;
    private Hashtable uriEngineMap = new Hashtable();

    public FunctionFactory(ParseContext parseContext) {
        this.pContext = parseContext;
    }

    public Instance getFunction(String string, String string2, String string3, Tree tree) throws SAXParseException {
        if (string.startsWith("java:")) {
            if (this.pContext.allowExternalFunctions) {
                return new ExtensionFunction(string.substring(5), string2, tree, this.pContext.locator);
            }
            throw new SAXParseException("No permission to call extension function `" + string3 + "'", this.pContext.locator);
        }
        if (this.scriptUriMap.containsValue(string)) {
            if (this.pContext.allowExternalFunctions) {
                return this.createScriptFunction(string, string2, string3);
            }
            throw new SAXParseException("No permission to call script function `" + string3 + "'", this.pContext.locator);
        }
        Instance instance = (Instance)functionHash.get("{" + string + "}" + string2);
        if (instance == null) {
            throw new SAXParseException("Unknown function `" + string3 + "'", this.pContext.locator);
        }
        int n = 0;
        if (tree != null) {
            n = 1;
            while (tree.type == 34) {
                tree = tree.left;
                ++n;
            }
        }
        if (n < instance.getMinParCount()) {
            throw new SAXParseException("Too few parameters in call of function `" + string3 + "' (" + instance.getMinParCount() + " needed)", this.pContext.locator);
        }
        if (n > instance.getMaxParCount()) {
            throw new SAXParseException("Too many parameters in call of function `" + string3 + "' (" + instance.getMaxParCount() + " allowed)", this.pContext.locator);
        }
        return instance;
    }

    static Value getOptionalValue(Context context, int n, Tree tree) throws SAXException {
        if (tree != null) {
            return tree.evaluate(context, n);
        }
        if (n > 0) {
            return new Value((SAXEvent)context.ancestorStack.elementAt(n - 1));
        }
        return Value.VAL_EMPTY;
    }

    private BSFManager getBSFManager() {
        if (this.bsfManager == null) {
            this.bsfManager = new BSFManager();
        }
        return this.bsfManager;
    }

    public boolean isScriptPrefix(String string) {
        return this.scriptUriMap.get(string) != null;
    }

    public void addScript(ScriptFactory.Instance instance, String string) throws SAXException {
        String string2 = instance.getPrefix();
        String string3 = instance.getUri();
        this.scriptUriMap.put(string2, string3);
        BSFEngine bSFEngine = null;
        try {
            bSFEngine = this.getBSFManager().loadScriptingEngine(instance.getLang());
            this.uriEngineMap.put(string3, bSFEngine);
        }
        catch (Exception exception) {
            throw new SAXParseException("Exception while creating scripting engine for prefix \ufffd" + string2 + "' and language `" + instance.getLang() + "'", instance.publicId, instance.systemId, instance.lineNo, instance.colNo, exception);
        }
        try {
            bSFEngine.exec("JoostScript", -1, -1, (Object)string);
        }
        catch (Exception exception) {
            throw new SAXParseException("Exception while executing the script for prefix `" + string2 + "'", instance.publicId, instance.systemId, instance.lineNo, instance.colNo, exception);
        }
    }

    private ScriptFunction createScriptFunction(String string, String string2, String string3) {
        return new ScriptFunction((BSFEngine)this.uriEngineMap.get(string), string2, string3);
    }

    static {
        Instance[] instanceArray = new Instance[]{new StringConv(), new NumberConv(), new BooleanConv(), new Position(), new HasChildNodes(), new NodeKind(), new Name(), new LocalName(), new NamespaceURI(), new GetNamespaceUriForPrefix(), new GetInScopePrefixes(), new Not(), new True(), new False(), new Floor(), new Ceiling(), new Round(), new Concat(), new StringJoin(), new StringLength(), new NormalizeSpace(), new Contains(), new StartsWith(), new EndsWith(), new Substring(), new SubstringBefore(), new SubstringAfter(), new Translate(), new StringPad(), new EscapeUri(), new Empty(), new Exists(), new ItemAt(), new IndexOf(), new Subsequence(), new InsertBefore(), new Remove(), new Count(), new Sum(), new Min(), new Max(), new Avg(), new FilterAvailable(), new ExtSequence()};
        functionHash = new Hashtable(instanceArray.length);
        for (int i = 0; i < instanceArray.length; ++i) {
            functionHash.put(instanceArray[i].getName(), instanceArray[i]);
        }
    }

    public static interface Instance {
        public int getMinParCount();

        public int getMaxParCount();

        public String getName();

        public Value evaluate(Context var1, int var2, Tree var3) throws SAXException, EvalException;
    }
}

