/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.stx.function;

import net.sf.joost.grammar.EvalException;
import net.sf.joost.grammar.Tree;
import net.sf.joost.stx.Context;
import net.sf.joost.stx.Value;
import net.sf.joost.stx.function.FunctionFactory;
import org.xml.sax.SAXException;

public final class ItemAt
implements FunctionFactory.Instance {
    public int getMinParCount() {
        return 2;
    }

    public int getMaxParCount() {
        return 2;
    }

    public String getName() {
        return "{http://stx.sourceforge.net/2003/functions}item-at";
    }

    public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
        Value value = tree.left.evaluate(context, n);
        double d = tree.right.evaluate(context, n).getNumberValue();
        if (value.type == 0 || Double.isNaN(d)) {
            return Value.VAL_EMPTY;
        }
        long l = Math.round(d);
        while (value != null && --l != 0L) {
            value = value.next;
        }
        if (value == null) {
            throw new EvalException("Position " + d + " out of bounds in call to function `" + this.getName().substring("{http://stx.sourceforge.net/2003/functions}".length()) + "'");
        }
        return value.singleCopy();
    }
}

