/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.stx.function;

import java.util.Stack;
import net.sf.joost.grammar.EvalException;
import net.sf.joost.grammar.Tree;
import net.sf.joost.instruction.AnalyzeTextFactory;
import net.sf.joost.stx.Context;
import net.sf.joost.stx.Value;
import net.sf.joost.stx.function.FunctionFactory;
import org.xml.sax.SAXException;

public final class RegexGroup
implements FunctionFactory.Instance {
    public int getMinParCount() {
        return 1;
    }

    public int getMaxParCount() {
        return 1;
    }

    public String getName() {
        return "{http://stx.sourceforge.net/2003/functions}regex-group";
    }

    public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
        Value value = tree.evaluate(context, n);
        double d = value.getNumberValue();
        Stack stack = (Stack)context.localVars.get(AnalyzeTextFactory.REGEX_GROUP);
        if (Double.isNaN(d) || d < 0.0 || stack == null || stack.size() == 0) {
            return Value.VAL_EMPTY_STRING;
        }
        String[] stringArray = (String[])stack.peek();
        int n2 = Math.round((float)d);
        if (n2 >= stringArray.length) {
            return Value.VAL_EMPTY_STRING;
        }
        return new Value(stringArray[n2]);
    }
}

