/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.stx.function;

import net.sf.joost.grammar.EvalException;
import net.sf.joost.grammar.Tree;
import net.sf.joost.stx.Context;
import net.sf.joost.stx.Value;
import net.sf.joost.stx.function.FunctionFactory;
import org.xml.sax.SAXException;

public final class StringPad
implements FunctionFactory.Instance {
    public int getMinParCount() {
        return 2;
    }

    public int getMaxParCount() {
        return 2;
    }

    public String getName() {
        return "{http://stx.sourceforge.net/2003/functions}string-pad";
    }

    public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
        String string = tree.left.evaluate(context, n).getStringValue();
        Value value = tree.right.evaluate(context, n);
        double d = value.getNumberValue();
        long l = Math.round(d);
        if (Double.isNaN(d) || l < 0L) {
            throw new EvalException("Invalid string-pad count " + value.getStringValue());
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (l-- > 0L) {
            stringBuffer.append(string);
        }
        return new Value(stringBuffer.toString());
    }
}

