/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.configuration;

import com.atlassian.user.GroupManager;
import com.atlassian.user.UserManager;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.DefaultRepositoryAccessor;
import com.atlassian.user.configuration.RepositoryAccessor;
import com.atlassian.user.configuration.RepositoryConfiguration;
import com.atlassian.user.configuration.RepositoryProcessor;
import com.atlassian.user.impl.hibernate.ExternalEntityDAO;
import com.atlassian.user.properties.PropertySetFactory;
import com.atlassian.user.repository.Repository;
import com.atlassian.user.search.query.EntityQueryParser;
import com.atlassian.user.security.authentication.Authenticator;
import com.atlassian.user.security.password.PasswordEncryptor;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import org.apache.log4j.Logger;

public abstract class AbstractRepositoryProcessor
implements RepositoryProcessor {
    protected static final Logger log = Logger.getLogger((Class)(class$com$atlassian$user$configuration$AbstractRepositoryProcessor == null ? (class$com$atlassian$user$configuration$AbstractRepositoryProcessor = AbstractRepositoryProcessor.class$("com.atlassian.user.configuration.AbstractRepositoryProcessor")) : class$com$atlassian$user$configuration$AbstractRepositoryProcessor));
    protected DefaultRepositoryAccessor repositoryAccessor = new DefaultRepositoryAccessor();
    protected Repository repository;
    protected UserManager userManager;
    protected GroupManager groupManager;
    protected PasswordEncryptor passwordEncryptor;
    protected Authenticator authenticator;
    protected PropertySetFactory propertySetFactory;
    protected EntityQueryParser entityQueryParser;
    protected ExternalEntityDAO externalEntityDAO;
    static /* synthetic */ Class class$com$atlassian$user$configuration$AbstractRepositoryProcessor;
    static /* synthetic */ Class class$com$atlassian$user$configuration$RepositoryProcessor;
    static /* synthetic */ Class class$com$atlassian$user$security$password$PasswordEncryptor;
    static /* synthetic */ Class class$com$atlassian$user$properties$PropertySetFactory;
    static /* synthetic */ Class class$com$atlassian$user$UserManager;
    static /* synthetic */ Class class$com$atlassian$user$GroupManager;
    static /* synthetic */ Class class$com$atlassian$user$security$authentication$Authenticator;
    static /* synthetic */ Class class$com$atlassian$user$search$query$EntityQueryParser;
    static /* synthetic */ Class class$com$atlassian$user$repository$Repository;

    public RepositoryAccessor process(HashMap components, HashMap componentClassNames) throws ConfigurationException {
        this.repository = this.configureRepository(components, componentClassNames);
        this.repositoryAccessor.setRepository(this.repository);
        this.propertySetFactory = this.configurePropertySetFactory(components, componentClassNames);
        this.repositoryAccessor.setPropertySetFactory(this.propertySetFactory);
        this.passwordEncryptor = this.configurePasswordEncryptor(components, componentClassNames);
        this.repositoryAccessor.setPasswordEncryptor(this.passwordEncryptor);
        this.userManager = this.configureUserManager(components, componentClassNames);
        this.repositoryAccessor.setUserManager(this.userManager);
        this.authenticator = this.configureAuthenticator(components, componentClassNames);
        this.repositoryAccessor.setAuthenticator(this.authenticator);
        this.groupManager = this.configureGroupManager(components, componentClassNames);
        this.repositoryAccessor.setGroupManager(this.groupManager);
        this.entityQueryParser = this.configureEntityQueryParser(components, componentClassNames);
        this.repositoryAccessor.setEntityQueryParser(this.entityQueryParser);
        String caching = (String)components.get("cache");
        if (caching != null && caching.equals("true")) {
            this.configureCaching(components);
        }
        return this.repositoryAccessor;
    }

    protected void configureCaching(HashMap components) throws ConfigurationException {
        RepositoryConfiguration cachingConfiguration = (RepositoryConfiguration)components.get("cacheConfig");
        String cacheRepositoryProcessorClassName = (String)cachingConfiguration.getComponentClassNames().get("processor");
        RepositoryProcessor cachingProcessor = (RepositoryProcessor)this.instantiateComponent(cacheRepositoryProcessorClassName, class$com$atlassian$user$configuration$RepositoryProcessor == null ? (class$com$atlassian$user$configuration$RepositoryProcessor = AbstractRepositoryProcessor.class$("com.atlassian.user.configuration.RepositoryProcessor")) : class$com$atlassian$user$configuration$RepositoryProcessor);
        cachingConfiguration.getComponents().put("underlyingComponents", components);
        RepositoryAccessor cachingRepositoryAccessor = cachingProcessor.process(cachingConfiguration.getComponents(), cachingConfiguration.getComponentClassNames());
        this.repositoryAccessor.setUserManager(cachingRepositoryAccessor.getUserManager());
        this.repositoryAccessor.setGroupManager(cachingRepositoryAccessor.getGroupManager());
        this.repositoryAccessor.setPropertySetFactory(cachingRepositoryAccessor.getPropertySetFactory());
    }

    public PasswordEncryptor configurePasswordEncryptor(HashMap components, HashMap componentClassNames) {
        String passwordEncryptorClassName = (String)componentClassNames.get("passwordEncryptor");
        if (passwordEncryptorClassName == null) {
            return null;
        }
        this.passwordEncryptor = (PasswordEncryptor)this.instantiateComponent(passwordEncryptorClassName, class$com$atlassian$user$security$password$PasswordEncryptor == null ? (class$com$atlassian$user$security$password$PasswordEncryptor = AbstractRepositoryProcessor.class$("com.atlassian.user.security.password.PasswordEncryptor")) : class$com$atlassian$user$security$password$PasswordEncryptor);
        this.passwordEncryptor.init(components);
        components.put("passwordEncryptor", this.passwordEncryptor);
        return this.passwordEncryptor;
    }

    protected Object instantiateComponent(String classname, Class classType) {
        Object o = null;
        try {
            Class<?> componentClass = Class.forName(classname);
            o = componentClass.newInstance();
            if (!classType.isInstance(o)) {
                throw new IllegalArgumentException("Invalid class " + classname + " not of type " + classType.getName());
            }
        }
        catch (Exception e) {
            log.error((Object)("Could not instantiate " + classType.getName() + " [" + classname + "]: " + e.getMessage()));
        }
        return o;
    }

    protected Object instantiateComponent(String classname, Class[] constructorArgClasses, Object[] constructorArgs) {
        Object object = null;
        try {
            Class<?> componentClass = Class.forName(classname);
            Constructor<?> constructor = componentClass.getConstructor(constructorArgClasses);
            object = constructor.newInstance(constructorArgs);
        }
        catch (Exception e) {
            log.error((Object)("Could not instantiate class: [" + classname + "]: " + e.getMessage()));
        }
        return object;
    }

    public PropertySetFactory configurePropertySetFactory(HashMap components, HashMap componentClassNames) throws ConfigurationException {
        String propertySetFactoryClassName = (String)componentClassNames.get("propertySetFactory");
        if (propertySetFactoryClassName == null) {
            return null;
        }
        this.propertySetFactory = (PropertySetFactory)this.instantiateComponent(propertySetFactoryClassName, class$com$atlassian$user$properties$PropertySetFactory == null ? (class$com$atlassian$user$properties$PropertySetFactory = AbstractRepositoryProcessor.class$("com.atlassian.user.properties.PropertySetFactory")) : class$com$atlassian$user$properties$PropertySetFactory);
        this.propertySetFactory.init(components);
        components.put("propertySetFactory", this.propertySetFactory);
        return this.propertySetFactory;
    }

    public UserManager configureUserManager(HashMap components, HashMap componentClassNames) throws ConfigurationException {
        String userManagerClassName = (String)componentClassNames.get("userManager");
        if (userManagerClassName == null) {
            return null;
        }
        this.userManager = (UserManager)this.instantiateComponent(userManagerClassName, class$com$atlassian$user$UserManager == null ? (class$com$atlassian$user$UserManager = AbstractRepositoryProcessor.class$("com.atlassian.user.UserManager")) : class$com$atlassian$user$UserManager);
        this.userManager.init(components);
        components.put("userManager", this.userManager);
        return this.userManager;
    }

    public GroupManager configureGroupManager(HashMap components, HashMap componentClassNames) throws ConfigurationException {
        String groupManagerClassName = (String)componentClassNames.get("groupManager");
        if (groupManagerClassName == null) {
            return null;
        }
        this.groupManager = (GroupManager)this.instantiateComponent(groupManagerClassName, class$com$atlassian$user$GroupManager == null ? (class$com$atlassian$user$GroupManager = AbstractRepositoryProcessor.class$("com.atlassian.user.GroupManager")) : class$com$atlassian$user$GroupManager);
        this.groupManager.init(components);
        components.put("groupManager", this.groupManager);
        return this.groupManager;
    }

    public Authenticator configureAuthenticator(HashMap components, HashMap componentClassNames) throws ConfigurationException {
        String authenticatorClassName = (String)componentClassNames.get("authenticator");
        if (authenticatorClassName == null) {
            return null;
        }
        this.authenticator = (Authenticator)this.instantiateComponent(authenticatorClassName, class$com$atlassian$user$security$authentication$Authenticator == null ? (class$com$atlassian$user$security$authentication$Authenticator = AbstractRepositoryProcessor.class$("com.atlassian.user.security.authentication.Authenticator")) : class$com$atlassian$user$security$authentication$Authenticator);
        this.authenticator.init(components);
        components.put("authenticator", this.authenticator);
        return this.authenticator;
    }

    public EntityQueryParser configureEntityQueryParser(HashMap components, HashMap componentClassNames) throws ConfigurationException {
        String entityQueryParserClassName = (String)componentClassNames.get("entityQueryParser");
        if (entityQueryParserClassName == null) {
            return null;
        }
        this.entityQueryParser = (EntityQueryParser)this.instantiateComponent(entityQueryParserClassName, class$com$atlassian$user$search$query$EntityQueryParser == null ? (class$com$atlassian$user$search$query$EntityQueryParser = AbstractRepositoryProcessor.class$("com.atlassian.user.search.query.EntityQueryParser")) : class$com$atlassian$user$search$query$EntityQueryParser);
        this.entityQueryParser.init(components);
        components.put("entityQueryParser", this.entityQueryParser);
        return this.entityQueryParser;
    }

    public Repository configureRepository(HashMap components, HashMap componentClassNames) throws ConfigurationException {
        String className = (String)componentClassNames.get("class");
        if (className == null) {
            return null;
        }
        this.repository = (Repository)this.instantiateComponent(className, class$com$atlassian$user$repository$Repository == null ? (class$com$atlassian$user$repository$Repository = AbstractRepositoryProcessor.class$("com.atlassian.user.repository.Repository")) : class$com$atlassian$user$repository$Repository);
        this.repository.init(components);
        components.put("repository", this.repository);
        return this.repository;
    }

    public RepositoryAccessor getRepositoryAccessor() {
        return this.repositoryAccessor;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

