/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.cache;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.util.InitializationCheck;
import com.atlassian.user.impl.cache.Cache;
import com.atlassian.user.impl.cache.CacheManager;
import com.atlassian.user.repository.Repository;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;
import java.util.Collection;
import java.util.HashMap;

public class CachingGroupManager
implements GroupManager {
    protected GroupManager underlyingGroupManager;
    protected CacheManager cacheManager;
    public String groupCacheName = null;
    public String hasMembershipCacheName = null;
    public String repositoryCacheName = null;
    public String groupsForUsersCacheName = null;
    protected static final String CACHE_SUFFIX_GROUPS = ".groups";
    protected static final String CACHE_SUFFIX_MEMBERSHIP = ".groups_hasMembership";
    protected static final String CACHE_SUFFIX_REPOSITORY = ".repositories";
    protected static final String CACHE_SUFFIX_GROUPS_FOR_USER = ".groups_getGroupsForUser";
    protected static final Group NULL_GROUP = new Group(){
        private String NAME = "NULL GROUP";

        public String getName() {
            return this.NAME;
        }

        public boolean equals(Object obj) {
            return obj == this;
        }
    };

    public CachingGroupManager() {
    }

    public CachingGroupManager(GroupManager underlyingGroupManager, CacheManager cacheManager) {
        this.underlyingGroupManager = underlyingGroupManager;
        this.cacheManager = cacheManager;
    }

    private Cache getGroupCache() {
        return this.cacheManager.getCache(this.groupCacheName);
    }

    private Cache getMembershipCheckCache() {
        return this.cacheManager.getCache(this.hasMembershipCacheName);
    }

    private Cache getRepositoryCache() {
        return this.cacheManager.getCache(this.repositoryCacheName);
    }

    private void cacheGroup(String groupname, Group group) {
        this.getGroupCache().put(groupname, group == null ? NULL_GROUP : group);
    }

    private void cacheMembershipCheck(User user, Group group, boolean val) {
        this.getMembershipCheckCache().put(this.getMembershipKey(user, group), val);
    }

    private void cacheRepository(String username, Repository repository) {
        this.getRepositoryCache().put(username, repository);
    }

    public Pager getGroups() throws EntityException {
        return this.underlyingGroupManager.getGroups();
    }

    public Pager getGroups(User user) throws EntityException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null.");
        }
        Cache groupsForUserCache = this.cacheManager.getCache(this.groupsForUsersCacheName);
        Collection cacheResult = (Collection)groupsForUserCache.get(user.getName());
        if (cacheResult != null) {
            return new DefaultPager(cacheResult);
        }
        Pager result = this.underlyingGroupManager.getGroups(user);
        groupsForUserCache.put(user.getName(), result.getCurrentPage());
        return result;
    }

    public Pager getMemberNames(Group group) throws EntityException {
        return this.underlyingGroupManager.getMemberNames(group);
    }

    public Pager getLocalMemberNames(Group group) throws EntityException {
        return this.underlyingGroupManager.getLocalMemberNames(group);
    }

    public Pager getExternalMemberNames(Group group) throws EntityException {
        return this.underlyingGroupManager.getExternalMemberNames(group);
    }

    public Group getGroup(String groupname) throws EntityException {
        Group cachedGroup = (Group)this.getGroupCache().get(groupname);
        if (cachedGroup != null) {
            return NULL_GROUP.equals(cachedGroup) ? null : cachedGroup;
        }
        Group group = this.underlyingGroupManager.getGroup(groupname);
        this.cacheGroup(groupname, group);
        return group;
    }

    public Group createGroup(String groupName) throws EntityException {
        Group createdGroup = this.underlyingGroupManager.createGroup(groupName);
        if (createdGroup != null) {
            this.cacheGroup(createdGroup.getName(), createdGroup);
        }
        return createdGroup;
    }

    public void removeGroup(Group group) throws EntityException {
        this.underlyingGroupManager.removeGroup(group);
        try {
            this.removeGroupFromCache(group);
        }
        catch (Exception e) {
            throw new EntityException(e);
        }
    }

    private void removeGroupFromCache(Group group) throws Exception {
        this.getGroupCache().remove(group.getName());
    }

    private void removeMembershipCheckFromCache(String entityname, String groupname) throws Exception {
        this.getMembershipCheckCache().remove(entityname + "_" + groupname);
    }

    public void addMembership(Group group, User user) throws EntityException {
        this.underlyingGroupManager.addMembership(group, user);
        this.cacheMembershipCheck(user, group, true);
    }

    private String getMembershipKey(User user, Group group) {
        return user.getName() + "_" + group.getName();
    }

    public boolean hasMembership(Group group, User user) throws EntityException {
        Boolean membershipCheckElement = (Boolean)this.getMembershipCheckCache().get(user.getName() + "_" + group.getName());
        if (membershipCheckElement != null) {
            return membershipCheckElement;
        }
        boolean membership = this.underlyingGroupManager.hasMembership(group, user);
        this.cacheMembershipCheck(user, group, membership);
        return membership;
    }

    public void removeMembership(Group group, User user) throws EntityException {
        this.underlyingGroupManager.removeMembership(group, user);
        try {
            this.removeMembershipCheckFromCache(user.getName(), group.getName());
        }
        catch (Exception e) {
            throw new EntityException(e);
        }
    }

    public boolean supportsExternalMembership() throws EntityException {
        return this.underlyingGroupManager.supportsExternalMembership();
    }

    public boolean isReadOnly(Group group) throws EntityException {
        return this.underlyingGroupManager.isReadOnly(group);
    }

    public Repository getRepository() {
        return this.underlyingGroupManager.getRepository();
    }

    public Repository getRepository(Entity entity) throws EntityException {
        Repository cachedRepository = (Repository)this.getRepositoryCache().get(entity.getName());
        if (cachedRepository == null) {
            Repository repository = this.underlyingGroupManager.getRepository(entity);
            this.cacheRepository(entity.getName(), repository);
            return repository;
        }
        return cachedRepository;
    }

    public boolean isCreative() {
        return this.underlyingGroupManager.isCreative();
    }

    public void init(HashMap args) throws ConfigurationException {
        this.cacheManager = (CacheManager)args.get("cacheManager");
        this.underlyingGroupManager = (GroupManager)args.get("groupManager");
        InitializationCheck.validateArgs(args, new String[]{"cacheManager", "groupManager"}, this);
        this.groupCacheName = this.underlyingGroupManager.getClass().getName() + CACHE_SUFFIX_GROUPS;
        this.hasMembershipCacheName = this.underlyingGroupManager.getClass().getName() + CACHE_SUFFIX_MEMBERSHIP;
        this.repositoryCacheName = this.underlyingGroupManager.getClass().getName() + CACHE_SUFFIX_REPOSITORY;
        this.groupsForUsersCacheName = this.underlyingGroupManager.getClass().getName() + CACHE_SUFFIX_GROUPS_FOR_USER;
    }
}

