/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.delegation;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.ExternalEntity;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.util.InitializationCheck;
import com.atlassian.user.impl.DuplicateEntityException;
import com.atlassian.user.impl.EntityMissingException;
import com.atlassian.user.impl.delegation.repository.DelegatingRepository;
import com.atlassian.user.repository.Repository;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.PagerFactory;
import com.atlassian.util.profiling.UtilTimerStack;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class DelegatingUserManager
implements UserManager {
    private static final Logger log = Logger.getLogger((Class)(class$com$atlassian$user$impl$delegation$DelegatingUserManager == null ? (class$com$atlassian$user$impl$delegation$DelegatingUserManager = DelegatingUserManager.class$("com.atlassian.user.impl.delegation.DelegatingUserManager")) : class$com$atlassian$user$impl$delegation$DelegatingUserManager));
    private UserManager leftUserManager;
    private UserManager rightUserManager;
    static /* synthetic */ Class class$com$atlassian$user$impl$delegation$DelegatingUserManager;

    public DelegatingUserManager() {
    }

    public DelegatingUserManager(UserManager leftUserManager, UserManager rightUserManager) {
        this.leftUserManager = leftUserManager;
        this.rightUserManager = rightUserManager;
    }

    public void init(HashMap args) throws ConfigurationException {
        this.leftUserManager = (UserManager)args.get("leftUserManager");
        this.rightUserManager = (UserManager)args.get("rightUserManager");
        InitializationCheck.validateArgs(args, new String[]{"leftUserManager", "rightUserManager"}, this);
    }

    public Pager getUsers() throws EntityException {
        Pager rightPager = null;
        Pager leftPager = null;
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_getUsers"));
        }
        try {
            if (UtilTimerStack.isActive()) {
                UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_getUsers__left"));
            }
            leftPager = this.leftUserManager.getUsers();
            if (UtilTimerStack.isActive()) {
                UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_getUsers__left"));
            }
        }
        catch (EntityException e) {
            log.error((Object)e.getMessage());
        }
        try {
            if (UtilTimerStack.isActive()) {
                UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_getUsers__right"));
            }
            rightPager = this.rightUserManager.getUsers();
            if (UtilTimerStack.isActive()) {
                UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_getUsers__right"));
            }
        }
        catch (EntityException e) {
            log.error((Object)e.getMessage());
        }
        Pager pager = PagerFactory.getPager(leftPager, rightPager);
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_getUsers"));
        }
        return pager;
    }

    public Pager getUserNames() throws EntityException {
        Pager leftPager = null;
        Pager rightPager = null;
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_getUserNames"));
        }
        log.debug((Object)".");
        try {
            if (UtilTimerStack.isActive()) {
                UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_getUserNames__left"));
            }
            leftPager = this.leftUserManager.getUserNames();
            if (UtilTimerStack.isActive()) {
                UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_getUserNames__left"));
            }
        }
        catch (EntityException e) {
            log.error((Object)e.getMessage());
        }
        try {
            if (UtilTimerStack.isActive()) {
                UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_getUserNames__right"));
            }
            rightPager = this.rightUserManager.getUserNames();
            if (UtilTimerStack.isActive()) {
                UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_getUserNames__right"));
            }
        }
        catch (EntityException e) {
            log.error((Object)e.getMessage());
        }
        Pager pager = PagerFactory.getPager(leftPager, rightPager);
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_getUsers"));
        }
        return pager;
    }

    public User getUser(String username) throws EntityException {
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_getUser__" + username));
        }
        log.debug((Object)(" - " + username));
        User user = this.leftUserManager.getUser(username);
        if (user == null) {
            user = this.rightUserManager.getUser(username);
        }
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_getUser__" + username));
        }
        return user;
    }

    public User createUser(String username) throws UnsupportedOperationException, EntityException {
        User preexistingUser = null;
        log.debug((Object)(" - " + username));
        try {
            preexistingUser = this.getUser(username);
        }
        catch (EntityException e) {
            log.error((Object)e.getMessage());
        }
        if (preexistingUser != null) {
            throw new DuplicateEntityException("User [" + username + "] already exists in " + this.getRepository(preexistingUser).getName());
        }
        if (this.leftUserManager.isCreative()) {
            return this.leftUserManager.createUser(username);
        }
        if (this.rightUserManager.isCreative()) {
            return this.rightUserManager.createUser(username);
        }
        throw new UnsupportedOperationException("Tried to create a group in a manager which cannot create entities.");
    }

    public void alterPassword(User user, String plaintextPass) throws EntityException {
        UserManager userManager = this.getManagerForUser(user);
        if (!userManager.isReadOnly(user)) {
            userManager.alterPassword(user, plaintextPass);
        } else {
            log.info((Object)("Cannot alter password on read-only user [" + user + "]"));
        }
    }

    public void saveUser(User user) throws EntityException {
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_saveUser__" + user.getName()));
        }
        UserManager userManager = this.getManagerForUser(user);
        userManager.saveUser(user);
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_saveUser__" + user.getName()));
        }
    }

    public void removeUser(User user) throws EntityException, UnsupportedOperationException {
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_removeUser__" + user.getName()));
        }
        UserManager um = this.getManagerForUser(user);
        um.removeUser(user);
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_removeUser__" + user.getName()));
        }
    }

    public boolean isReadOnly(User user) throws EntityException {
        return this.getManagerForUser(user).isReadOnly(user);
    }

    public Repository getRepository() {
        return new DelegatingRepository(this.leftUserManager.getRepository(), this.rightUserManager.getRepository());
    }

    public Repository getRepository(Entity entity) throws EntityException {
        Repository homeRepository = null;
        if (entity instanceof User) {
            UserManager um = this.getManagerForUser((User)entity);
            if (um == null) {
                throw new EntityMissingException("No matching userManager for [" + entity.getName() + "]");
            }
            homeRepository = um.getRepository();
        } else if (entity instanceof ExternalEntity && (homeRepository = this.leftUserManager.getRepository(entity)) == null) {
            homeRepository = this.rightUserManager.getRepository(entity);
        }
        if (homeRepository == null) {
            log.info((Object)("Could not identify a repository for entity: [" + entity + "], " + entity.getClass().getName()));
        }
        return homeRepository;
    }

    public boolean isCreative() {
        return this.leftUserManager.isCreative() || this.rightUserManager.isCreative();
    }

    private UserManager getManagerForUser(User user) {
        UserManager leftResult = this.getManagerForUser(user, this.leftUserManager);
        if (leftResult != null) {
            return leftResult;
        }
        UserManager rightResult = this.getManagerForUser(user, this.rightUserManager);
        if (rightResult != null) {
            return rightResult;
        }
        log.error((Object)("Could not find a manager to handle user: '" + (user != null ? user.getName() : "<null>") + "'"));
        return null;
    }

    private UserManager getManagerForUser(User user, UserManager userManager) {
        if (userManager instanceof DelegatingUserManager) {
            return ((DelegatingUserManager)userManager).getManagerForUser(user);
        }
        try {
            if (userManager.getUser(user.getName()) != null) {
                return userManager;
            }
        }
        catch (EntityException e) {
            log.error((Object)"Could not get user.", (Throwable)e);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

